/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.org.apache.avro.LogicalTypes;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericArray;
import org.apache.hudi.org.apache.avro.generic.GenericFixed;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRealtimeRecordReaderUtils {
    private static final Logger LOG = LogManager.getLogger(HoodieRealtimeRecordReaderUtils.class);

    public static Schema readSchema(Configuration conf, Path filePath) {
        try {
            HoodieFileReader storageReader = HoodieFileReaderFactory.getFileReader(conf, filePath);
            return storageReader.getSchema();
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read schema from " + filePath, e);
        }
    }

    public static long getMaxCompactionMemoryInBytes(JobConf jobConf) {
        return (long)Math.ceil(Double.parseDouble(jobConf.get("compaction.memory.fraction", "0.75")) * (double)jobConf.getMemoryForMapTask() * 1024.0 * 1024.0);
    }

    public static String arrayWritableToString(ArrayWritable writable) {
        if (writable == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        Writable[] values = writable.get();
        builder.append("\"values_" + Math.random() + "_" + values.length + "\": {");
        int i = 0;
        for (Writable w : values) {
            if (w instanceof ArrayWritable) {
                builder.append(HoodieRealtimeRecordReaderUtils.arrayWritableToString((ArrayWritable)w)).append(",");
            } else {
                builder.append("\"value" + i + "\":\"" + w + "\"").append(",");
                if (w == null) {
                    builder.append("\"type" + i + "\":\"unknown\"").append(",");
                } else {
                    builder.append("\"type" + i + "\":\"" + w.getClass().getSimpleName() + "\"").append(",");
                }
            }
            ++i;
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public static Schema generateProjectionSchema(Schema writeSchema, Map<String, Schema.Field> schemaFieldsMap, List<String> fieldNames) {
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field = schemaFieldsMap.get(fn.toLowerCase());
            if (field == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
        }
        Schema projectedSchema = Schema.createRecord(writeSchema.getName(), writeSchema.getDoc(), writeSchema.getNamespace(), writeSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static Map<String, Schema.Field> getNameToFieldMap(Schema schema) {
        return schema.getFields().stream().map(r -> Pair.of(r.name().toLowerCase(), r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public static Writable avroToArrayWritable(Object value, Schema schema) {
        if (value == null) {
            return null;
        }
        switch (schema.getType()) {
            case STRING: {
                return new Text(value.toString());
            }
            case BYTES: {
                return new BytesWritable(((ByteBuffer)value).array());
            }
            case INT: {
                return new IntWritable(((Integer)value).intValue());
            }
            case LONG: {
                return new LongWritable(((Long)value).longValue());
            }
            case FLOAT: {
                return new FloatWritable(((Float)value).floatValue());
            }
            case DOUBLE: {
                return new DoubleWritable(((Double)value).doubleValue());
            }
            case BOOLEAN: {
                return new BooleanWritable(((Boolean)value).booleanValue());
            }
            case NULL: {
                return null;
            }
            case RECORD: {
                GenericRecord record = (GenericRecord)value;
                Writable[] recordValues = new Writable[schema.getFields().size()];
                int recordValueIndex = 0;
                for (Schema.Field field : schema.getFields()) {
                    recordValues[recordValueIndex++] = HoodieRealtimeRecordReaderUtils.avroToArrayWritable(record.get(field.name()), field.schema());
                }
                return new ArrayWritable(Writable.class, recordValues);
            }
            case ENUM: {
                return new Text(value.toString());
            }
            case ARRAY: {
                GenericArray arrayValue = (GenericArray)value;
                Writable[] arrayValues = new Writable[arrayValue.size()];
                int arrayValueIndex = 0;
                for (Object obj : arrayValue) {
                    arrayValues[arrayValueIndex++] = HoodieRealtimeRecordReaderUtils.avroToArrayWritable(obj, schema.getElementType());
                }
                return new ArrayWritable(Writable.class, arrayValues);
            }
            case MAP: {
                Map mapValue = (Map)value;
                Writable[] mapValues = new Writable[mapValue.size()];
                int mapValueIndex = 0;
                Iterator iterator = mapValue.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry mapEntry = entry = iterator.next();
                    Writable[] nestedMapValues = new Writable[]{new Text(mapEntry.getKey().toString()), HoodieRealtimeRecordReaderUtils.avroToArrayWritable(mapEntry.getValue(), schema.getValueType())};
                    mapValues[mapValueIndex++] = new ArrayWritable(Writable.class, nestedMapValues);
                }
                return new ArrayWritable(Writable.class, mapValues);
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() != 2) {
                    throw new IllegalArgumentException("Only support union with 2 fields");
                }
                Schema s1 = types.get(0);
                Schema s2 = types.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return HoodieRealtimeRecordReaderUtils.avroToArrayWritable(value, s2);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return HoodieRealtimeRecordReaderUtils.avroToArrayWritable(value, s1);
                }
                throw new IllegalArgumentException("Only support union with null");
            }
            case FIXED: {
                if (schema.getLogicalType() != null && schema.getLogicalType().getName().equals("decimal")) {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)LogicalTypes.fromSchema(schema);
                    HiveDecimalWritable writable = new HiveDecimalWritable(((GenericFixed)value).bytes(), decimal.getScale());
                    return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)writable, (DecimalTypeInfo)new DecimalTypeInfo(decimal.getPrecision(), decimal.getScale()));
                }
                return new BytesWritable(((GenericFixed)value).bytes());
            }
        }
        return null;
    }

    public static List<String> orderFields(String fieldNameCsv, String fieldOrderCsv, List<String> partitioningFields) {
        String[] fieldOrdersWithDups = fieldOrderCsv.isEmpty() ? new String[]{} : fieldOrderCsv.split(",");
        LinkedHashSet<String> fieldOrdersSet = new LinkedHashSet<String>(Arrays.asList(fieldOrdersWithDups));
        String[] fieldOrders = fieldOrdersSet.toArray(new String[0]);
        List<Object> fieldNames = fieldNameCsv.isEmpty() ? new ArrayList() : Arrays.stream(fieldNameCsv.split(",")).filter(fn -> !partitioningFields.contains(fn)).collect(Collectors.toList());
        LinkedHashSet fieldNamesSet = new LinkedHashSet(fieldNames);
        if (fieldNamesSet.size() != fieldOrders.length) {
            throw new HoodieException(String.format("Error ordering fields for storage read. #fieldNames: %d, #fieldPositions: %d", fieldNames.size(), fieldOrders.length));
        }
        TreeMap<Integer, String> orderedFieldMap = new TreeMap<Integer, String>();
        String[] fieldNamesArray = fieldNamesSet.toArray(new String[0]);
        for (int ox = 0; ox < fieldOrders.length; ++ox) {
            orderedFieldMap.put(Integer.parseInt(fieldOrders[ox]), fieldNamesArray[ox]);
        }
        return new ArrayList<String>(orderedFieldMap.values());
    }

    public static Schema addPartitionFields(Schema schema, List<String> partitioningFields) {
        Set firstLevelFieldNames = schema.getFields().stream().map(Schema.Field::name).map(String::toLowerCase).collect(Collectors.toSet());
        List<String> fieldsToAdd = partitioningFields.stream().map(String::toLowerCase).filter(x -> !firstLevelFieldNames.contains(x)).collect(Collectors.toList());
        return HoodieAvroUtils.appendNullSchemaFields(schema, fieldsToAdd);
    }
}

