/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.Context;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCipherProvider {
    @Test
    public void testCustomProvider() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.crypto.cipherprovider", MyCipherProvider.class.getName());
        CipherProvider provider = Encryption.getCipherProvider(conf);
        Assert.assertTrue((boolean)(provider instanceof MyCipherProvider));
        Assert.assertTrue((boolean)Arrays.asList(provider.getSupportedCiphers()).contains("TEST"));
        Cipher a = Encryption.getCipher(conf, "TEST");
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a.getProvider() instanceof MyCipherProvider));
        Assert.assertEquals((Object)a.getName(), (Object)"TEST");
        Assert.assertEquals((long)a.getKeyLength(), (long)0L);
    }

    @Test
    public void testDefaultProvider() {
        Configuration conf = HBaseConfiguration.create();
        CipherProvider provider = Encryption.getCipherProvider(conf);
        Assert.assertTrue((boolean)(provider instanceof DefaultCipherProvider));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Assert.assertTrue((boolean)Arrays.asList(provider.getSupportedCiphers()).contains(algorithm));
        Cipher a = Encryption.getCipher(conf, algorithm);
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a.getProvider() instanceof DefaultCipherProvider));
        Assert.assertEquals((Object)a.getName(), (Object)algorithm);
        Assert.assertEquals((long)a.getKeyLength(), (long)16L);
    }

    public static class MyCipherProvider
    implements CipherProvider {
        private Configuration conf;

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public String getName() {
            return MyCipherProvider.class.getName();
        }

        @Override
        public String[] getSupportedCiphers() {
            return new String[]{"TEST"};
        }

        @Override
        public Cipher getCipher(String name) {
            if (name.equals("TEST")) {
                return new Cipher(this){

                    @Override
                    public String getName() {
                        return "TEST";
                    }

                    @Override
                    public int getKeyLength() {
                        return 0;
                    }

                    @Override
                    public int getIvLength() {
                        return 0;
                    }

                    @Override
                    public Key getRandomKey() {
                        return null;
                    }

                    @Override
                    public Encryptor getEncryptor() {
                        return null;
                    }

                    @Override
                    public Decryptor getDecryptor() {
                        return null;
                    }

                    @Override
                    public OutputStream createEncryptionStream(OutputStream out, Context context, byte[] iv) throws IOException {
                        return null;
                    }

                    @Override
                    public OutputStream createEncryptionStream(OutputStream out, Encryptor encryptor) throws IOException {
                        return null;
                    }

                    @Override
                    public InputStream createDecryptionStream(InputStream in, Context context, byte[] iv) throws IOException {
                        return null;
                    }

                    @Override
                    public InputStream createDecryptionStream(InputStream in, Decryptor decryptor) throws IOException {
                        return null;
                    }
                };
            }
            return null;
        }
    }
}

