/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedString;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.types.RawBytesTerminated;
import org.apache.hadoop.hbase.types.TerminatedWrapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTerminatedWrapper {
    static final String[] VALUES_STRINGS = new String[]{"", "1", "22", "333", "4444", "55555", "666666", "7777777", "88888888", "999999999"};
    static final byte[][] VALUES_BYTES = new byte[VALUES_STRINGS.length][];
    static final byte[][] TERMINATORS;

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyDelimiter() {
        new TerminatedWrapper<byte[]>(new RawBytes(), "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDelimiter() {
        new RawBytesTerminated((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEncodedValueContainsTerm() {
        TerminatedWrapper<byte[]> type = new TerminatedWrapper<byte[]>(new RawBytes(), "foo");
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(16);
        type.encode(buff, Bytes.toBytes("hello foobar!"));
    }

    @Test
    public void testReadWriteSkippable() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(14);
        for (OrderedString t : new OrderedString[]{OrderedString.ASCENDING, OrderedString.DESCENDING}) {
            for (byte[] term : TERMINATORS) {
                for (String val : VALUES_STRINGS) {
                    buff.setPosition(0);
                    TerminatedWrapper<String> type = new TerminatedWrapper<String>(t, term);
                    Assert.assertEquals((long)(val.length() + 2 + term.length), (long)type.encode(buff, val));
                    buff.setPosition(0);
                    Assert.assertEquals((Object)val, type.decode(buff));
                    Assert.assertEquals((long)(val.length() + 2 + term.length), (long)buff.getPosition());
                }
            }
        }
    }

    @Test
    public void testReadWriteNonSkippable() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(12);
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (byte[] term : TERMINATORS) {
                for (byte[] val : VALUES_BYTES) {
                    buff.setPosition(0);
                    TerminatedWrapper<byte[]> type = new TerminatedWrapper<byte[]>(new RawBytes(ord), term);
                    Assert.assertEquals((long)(val.length + term.length), (long)type.encode(buff, val));
                    buff.setPosition(0);
                    Assert.assertArrayEquals((byte[])val, (byte[])((byte[])type.decode(buff)));
                    Assert.assertEquals((long)(val.length + term.length), (long)buff.getPosition());
                }
            }
        }
    }

    @Test
    public void testSkipSkippable() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(14);
        for (OrderedString t : new OrderedString[]{OrderedString.ASCENDING, OrderedString.DESCENDING}) {
            for (byte[] term : TERMINATORS) {
                for (String val : VALUES_STRINGS) {
                    buff.setPosition(0);
                    TerminatedWrapper<String> type = new TerminatedWrapper<String>(t, term);
                    int expected = val.length() + 2 + term.length;
                    Assert.assertEquals((long)expected, (long)type.encode(buff, val));
                    buff.setPosition(0);
                    Assert.assertEquals((long)expected, (long)type.skip(buff));
                    Assert.assertEquals((long)expected, (long)buff.getPosition());
                }
            }
        }
    }

    @Test
    public void testSkipNonSkippable() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(12);
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (byte[] term : TERMINATORS) {
                for (byte[] val : VALUES_BYTES) {
                    buff.setPosition(0);
                    TerminatedWrapper<byte[]> type = new TerminatedWrapper<byte[]>(new RawBytes(ord), term);
                    int expected = type.encode(buff, val);
                    buff.setPosition(0);
                    Assert.assertEquals((long)expected, (long)type.skip(buff));
                    Assert.assertEquals((long)expected, (long)buff.getPosition());
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSkip() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(Bytes.toBytes("foo"));
        TerminatedWrapper<byte[]> type = new TerminatedWrapper<byte[]>(new RawBytes(), new byte[]{0});
        type.skip(buff);
    }

    static {
        for (int i = 0; i < VALUES_STRINGS.length; ++i) {
            TestTerminatedWrapper.VALUES_BYTES[i] = Bytes.toBytes(VALUES_STRINGS[i]);
        }
        TERMINATORS = new byte[][]{{-2}, Bytes.toBytes("foo")};
    }
}

