/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class RegionSizeCalculator {
    private static final Log LOG = LogFactory.getLog(RegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RegionSizeCalculator(HTable table) throws IOException {
        try (HBaseAdmin admin = new HBaseAdmin(table.getConfiguration());){
            this.init(table.getRegionLocator(), admin);
        }
    }

    public RegionSizeCalculator(RegionLocator regionLocator, Admin admin) throws IOException {
        this.init(regionLocator, admin);
    }

    private void init(RegionLocator regionLocator, Admin admin) throws IOException {
        if (!this.enabled(admin.getConfiguration())) {
            LOG.info((Object)"Region size calculation disabled.");
            return;
        }
        LOG.info((Object)("Calculating region sizes for table \"" + regionLocator.getName() + "\"."));
        List<HRegionLocation> tableRegionInfos = regionLocator.getAllRegionLocations();
        TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (HRegionLocation regionInfo : tableRegionInfos) {
            tableRegions.add(regionInfo.getRegionInfo().getRegionName());
        }
        ClusterStatus clusterStatus = admin.getClusterStatus();
        Collection<ServerName> servers = clusterStatus.getServers();
        long megaByte = 0x100000L;
        for (ServerName serverName : servers) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                byte[] regionId = regionLoad.getName();
                if (!tableRegions.contains(regionId)) continue;
                long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                this.sizeMap.put(regionId, regionSizeBytes);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Region " + regionLoad.getNameAsString() + " has size " + regionSizeBytes));
            }
        }
        LOG.debug((Object)"Region sizes calculated");
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            LOG.debug((Object)("Unknown region:" + Arrays.toString(regionId)));
            return 0L;
        }
        return size;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }
}

