/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public final class HoodieLocalEngineContext
extends HoodieEngineContext {
    public HoodieLocalEngineContext(Configuration conf) {
        this(conf, (TaskContextSupplier)new LocalTaskContextSupplier());
    }

    public HoodieLocalEngineContext(Configuration conf, TaskContextSupplier taskContextSupplier) {
        super(new SerializableConfiguration(conf), taskContextSupplier);
    }

    @Override
    public <I, O> List<O> map(List<I> data, SerializableFunction<I, O> func, int parallelism) {
        return ((Stream)data.stream().parallel()).map(FunctionWrapper.throwingMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I, O> List<O> flatMap(List<I> data, SerializableFunction<I, Stream<O>> func, int parallelism) {
        return ((Stream)data.stream().parallel()).flatMap(FunctionWrapper.throwingFlatMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I> void foreach(List<I> data, SerializableConsumer<I> consumer, int parallelism) {
        data.stream().forEach(FunctionWrapper.throwingForeachWrapper(consumer));
    }

    @Override
    public <I, K, V> Map<K, V> mapToPair(List<I> data, SerializablePairFunction<I, K, V> func, Integer parallelism) {
        return data.stream().map(FunctionWrapper.throwingMapToPairWrapper(func)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (oldVal, newVal) -> newVal));
    }

    @Override
    public void setProperty(EngineProperty key, String value) {
    }

    @Override
    public Option<String> getProperty(EngineProperty key) {
        return Option.empty();
    }

    @Override
    public void setJobStatus(String activeModule, String activityDescription) {
    }
}

