/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableConfig
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieTableConfig.class);
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final String HOODIE_TABLE_NAME_PROP_NAME = "hoodie.table.name";
    public static final String HOODIE_TABLE_TYPE_PROP_NAME = "hoodie.table.type";
    public static final String HOODIE_TABLE_VERSION_PROP_NAME = "hoodie.table.version";
    public static final String HOODIE_TABLE_PRECOMBINE_FIELD = "hoodie.table.precombine.field";
    @Deprecated
    public static final String HOODIE_RO_FILE_FORMAT_PROP_NAME = "hoodie.table.ro.file.format";
    @Deprecated
    public static final String HOODIE_RT_FILE_FORMAT_PROP_NAME = "hoodie.table.rt.file.format";
    public static final String HOODIE_BASE_FILE_FORMAT_PROP_NAME = "hoodie.table.base.file.format";
    public static final String HOODIE_LOG_FILE_FORMAT_PROP_NAME = "hoodie.table.log.file.format";
    public static final String HOODIE_TIMELINE_LAYOUT_VERSION = "hoodie.timeline.layout.version";
    public static final String HOODIE_PAYLOAD_CLASS_PROP_NAME = "hoodie.compaction.payload.class";
    public static final String HOODIE_ARCHIVELOG_FOLDER_PROP_NAME = "hoodie.archivelog.folder";
    public static final String HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME = "hoodie.bootstrap.index.class";
    public static final String HOODIE_BOOTSTRAP_BASE_PATH = "hoodie.bootstrap.base.path";
    public static final HoodieTableType DEFAULT_TABLE_TYPE = HoodieTableType.COPY_ON_WRITE;
    public static final HoodieTableVersion DEFAULT_TABLE_VERSION = HoodieTableVersion.ZERO;
    public static final HoodieFileFormat DEFAULT_BASE_FILE_FORMAT = HoodieFileFormat.PARQUET;
    public static final HoodieFileFormat DEFAULT_LOG_FILE_FORMAT = HoodieFileFormat.HOODIE_LOG;
    public static final String DEFAULT_PAYLOAD_CLASS = OverwriteWithLatestAvroPayload.class.getName();
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = HFileBootstrapIndex.class.getName();
    public static final String DEFAULT_ARCHIVELOG_FOLDER = "";
    private Properties props;

    public HoodieTableConfig(FileSystem fs, String metaPath, String payloadClassName) {
        Properties props;
        block27: {
            props = new Properties();
            Path propertyPath = new Path(metaPath, HOODIE_PROPERTIES_FILE);
            LOG.info((Object)("Loading table properties from " + propertyPath));
            try {
                try (FSDataInputStream inputStream = fs.open(propertyPath);){
                    props.load((InputStream)inputStream);
                }
                if (!props.containsKey(HOODIE_PAYLOAD_CLASS_PROP_NAME) || payloadClassName == null || props.getProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME).equals(payloadClassName)) break block27;
                props.setProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME, payloadClassName);
                var7_8 = null;
                try (FSDataOutputStream outputStream = fs.create(propertyPath);){
                    props.store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
                }
                catch (Throwable throwable) {
                    var7_8 = throwable;
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Could not load Hoodie properties from " + propertyPath, e);
            }
        }
        this.props = props;
        ValidationUtils.checkArgument(props.containsKey(HOODIE_TABLE_TYPE_PROP_NAME) && props.containsKey(HOODIE_TABLE_NAME_PROP_NAME), "hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
    }

    public HoodieTableConfig(Properties props) {
        this.props = props;
    }

    public HoodieTableConfig() {
    }

    public static void createHoodieProperties(FileSystem fs, Path metadataFolder, Properties properties) throws IOException {
        if (!fs.exists(metadataFolder)) {
            fs.mkdirs(metadataFolder);
        }
        Path propertyPath = new Path(metadataFolder, HOODIE_PROPERTIES_FILE);
        try (FSDataOutputStream outputStream = fs.create(propertyPath);){
            if (!properties.containsKey(HOODIE_TABLE_NAME_PROP_NAME)) {
                throw new IllegalArgumentException("hoodie.table.name property needs to be specified");
            }
            if (!properties.containsKey(HOODIE_TABLE_TYPE_PROP_NAME)) {
                properties.setProperty(HOODIE_TABLE_TYPE_PROP_NAME, DEFAULT_TABLE_TYPE.name());
            }
            if (properties.getProperty(HOODIE_TABLE_TYPE_PROP_NAME).equals(HoodieTableType.MERGE_ON_READ.name()) && !properties.containsKey(HOODIE_PAYLOAD_CLASS_PROP_NAME)) {
                properties.setProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME, DEFAULT_PAYLOAD_CLASS);
            }
            if (!properties.containsKey(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME)) {
                properties.setProperty(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME, DEFAULT_ARCHIVELOG_FOLDER);
            }
            if (!properties.containsKey(HOODIE_TIMELINE_LAYOUT_VERSION)) {
                properties.setProperty(HOODIE_TIMELINE_LAYOUT_VERSION, TimelineLayoutVersion.CURR_VERSION.toString());
            }
            if (properties.containsKey(HOODIE_BOOTSTRAP_BASE_PATH) && !properties.containsKey(HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME)) {
                properties.setProperty(HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME, DEFAULT_BOOTSTRAP_INDEX_CLASS);
            }
            properties.store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
        }
    }

    public HoodieTableType getTableType() {
        if (this.props.containsKey(HOODIE_TABLE_TYPE_PROP_NAME)) {
            return HoodieTableType.valueOf(this.props.getProperty(HOODIE_TABLE_TYPE_PROP_NAME));
        }
        return DEFAULT_TABLE_TYPE;
    }

    public Option<TimelineLayoutVersion> getTimelineLayoutVersion() {
        return this.props.containsKey(HOODIE_TIMELINE_LAYOUT_VERSION) ? Option.of(new TimelineLayoutVersion(Integer.valueOf(this.props.getProperty(HOODIE_TIMELINE_LAYOUT_VERSION)))) : Option.empty();
    }

    public HoodieTableVersion getTableVersion() {
        return this.props.containsKey(HOODIE_TABLE_VERSION_PROP_NAME) ? HoodieTableVersion.versionFromCode(Integer.parseInt(this.props.getProperty(HOODIE_TABLE_VERSION_PROP_NAME))) : DEFAULT_TABLE_VERSION;
    }

    public void setTableVersion(HoodieTableVersion tableVersion) {
        this.props.put(HOODIE_TABLE_VERSION_PROP_NAME, Integer.toString(tableVersion.versionCode()));
    }

    public String getPayloadClass() {
        return this.props.getProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME, DEFAULT_PAYLOAD_CLASS).replace("com.uber.hoodie", "org.apache.hudi");
    }

    public String getPreCombineField() {
        return this.props.getProperty(HOODIE_TABLE_PRECOMBINE_FIELD);
    }

    public String getBootstrapIndexClass() {
        return this.props.getProperty(HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME, DEFAULT_BOOTSTRAP_INDEX_CLASS);
    }

    public Option<String> getBootstrapBasePath() {
        return Option.ofNullable(this.props.getProperty(HOODIE_BOOTSTRAP_BASE_PATH));
    }

    public String getTableName() {
        return this.props.getProperty(HOODIE_TABLE_NAME_PROP_NAME);
    }

    public HoodieFileFormat getBaseFileFormat() {
        if (this.props.containsKey(HOODIE_BASE_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_BASE_FILE_FORMAT_PROP_NAME));
        }
        if (this.props.containsKey(HOODIE_RO_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_RO_FILE_FORMAT_PROP_NAME));
        }
        return DEFAULT_BASE_FILE_FORMAT;
    }

    public HoodieFileFormat getLogFileFormat() {
        if (this.props.containsKey(HOODIE_LOG_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_LOG_FILE_FORMAT_PROP_NAME));
        }
        if (this.props.containsKey(HOODIE_RT_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_RT_FILE_FORMAT_PROP_NAME));
        }
        return DEFAULT_LOG_FILE_FORMAT;
    }

    public String getArchivelogFolder() {
        return this.props.getProperty(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME, DEFAULT_ARCHIVELOG_FOLDER);
    }

    public Map<String, String> getProps() {
        return this.props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }

    public Properties getProperties() {
        return this.props;
    }
}

