/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableMetaClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieTableMetaClient.class);
    public static final String METAFOLDER_NAME = ".hoodie";
    public static final String TEMPFOLDER_NAME = ".hoodie" + File.separator + ".temp";
    public static final String AUXILIARYFOLDER_NAME = ".hoodie" + File.separator + ".aux";
    public static final String BOOTSTRAP_INDEX_ROOT_FOLDER_PATH = AUXILIARYFOLDER_NAME + File.separator + ".bootstrap";
    public static final String HEARTBEAT_FOLDER_NAME = ".hoodie" + File.separator + ".heartbeat";
    public static final String BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH = BOOTSTRAP_INDEX_ROOT_FOLDER_PATH + "/" + ".partitions";
    public static final String BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH = BOOTSTRAP_INDEX_ROOT_FOLDER_PATH + "/" + ".fileids";
    public static final String MARKER_EXTN = ".marker";
    private String basePath;
    private transient HoodieWrapperFileSystem fs;
    private String metaPath;
    private boolean loadActiveTimelineOnLoad;
    private SerializableConfiguration hadoopConf;
    private HoodieTableType tableType;
    private TimelineLayoutVersion timelineLayoutVersion;
    private HoodieTableConfig tableConfig;
    private HoodieActiveTimeline activeTimeline;
    private HoodieArchivedTimeline archivedTimeline;
    private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();

    private HoodieTableMetaClient(Configuration conf, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, String payloadClassName) {
        LOG.info((Object)("Loading HoodieTableMetaClient from " + basePath));
        this.consistencyGuardConfig = consistencyGuardConfig;
        this.hadoopConf = new SerializableConfiguration(conf);
        Path basePathDir = new Path(basePath);
        this.basePath = basePathDir.toString();
        this.metaPath = new Path(basePath, METAFOLDER_NAME).toString();
        Path metaPathDir = new Path(this.metaPath);
        this.fs = this.getFs();
        TableNotFoundException.checkTableValidity(this.fs, basePathDir, metaPathDir);
        this.tableConfig = new HoodieTableConfig(this.fs, this.metaPath, payloadClassName);
        this.tableType = this.tableConfig.getTableType();
        Option<TimelineLayoutVersion> tableConfigVersion = this.tableConfig.getTimelineLayoutVersion();
        if (layoutVersion.isPresent() && tableConfigVersion.isPresent()) {
            ValidationUtils.checkArgument(layoutVersion.get().compareTo(tableConfigVersion.get()) >= 0, "Layout Version defined in hoodie properties has higher version (" + tableConfigVersion.get() + ") than the one passed in config (" + layoutVersion.get() + ")");
        }
        this.timelineLayoutVersion = layoutVersion.orElseGet(() -> this.tableConfig.getTimelineLayoutVersion().get());
        this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
        LOG.info((Object)("Finished Loading Table of type " + (Object)((Object)this.tableType) + "(version=" + this.timelineLayoutVersion + ", baseFileFormat=" + (Object)((Object)this.tableConfig.getBaseFileFormat()) + ") from " + basePath));
        if (loadActiveTimelineOnLoad) {
            LOG.info((Object)("Loading Active commit timeline for " + basePath));
            this.getActiveTimeline();
        }
    }

    public HoodieTableMetaClient() {
    }

    public static HoodieTableMetaClient reload(HoodieTableMetaClient oldMetaClient) {
        return HoodieTableMetaClient.builder().setConf(oldMetaClient.hadoopConf.get()).setBasePath(oldMetaClient.basePath).setLoadActiveTimelineOnLoad(oldMetaClient.loadActiveTimelineOnLoad).setConsistencyGuardConfig(oldMetaClient.consistencyGuardConfig).setLayoutVersion(Option.of(oldMetaClient.timelineLayoutVersion)).setPayloadClassName(null).build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fs = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public String getMetaPath() {
        return this.metaPath;
    }

    public String getTempFolderPath() {
        return this.basePath + "/" + TEMPFOLDER_NAME;
    }

    public String getMarkerFolderPath(String instantTs) {
        return String.format("%s%s%s", this.getTempFolderPath(), "/", instantTs);
    }

    public String getMetaAuxiliaryPath() {
        return this.basePath + "/" + AUXILIARYFOLDER_NAME;
    }

    public static String getHeartbeatFolderPath(String basePath) {
        return String.format("%s%s%s", basePath, File.separator, HEARTBEAT_FOLDER_NAME);
    }

    public String getBootstrapIndexByPartitionFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH;
    }

    public String getBootstrapIndexByFileIdFolderNameFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH;
    }

    public String getArchivePath() {
        String archiveFolder = this.tableConfig.getArchivelogFolder();
        if (archiveFolder.equals("")) {
            return this.getMetaPath();
        }
        return this.getMetaPath() + "/" + archiveFolder;
    }

    public HoodieTableConfig getTableConfig() {
        return this.tableConfig;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public HoodieWrapperFileSystem getFs() {
        if (this.fs == null) {
            FileSystem fileSystem = FSUtils.getFs(this.metaPath, this.hadoopConf.newCopy());
            ValidationUtils.checkArgument(!(fileSystem instanceof HoodieWrapperFileSystem), "File System not expected to be that of HoodieWrapperFileSystem");
            this.fs = new HoodieWrapperFileSystem(fileSystem, this.consistencyGuardConfig.isConsistencyCheckEnabled() ? new FailSafeConsistencyGuard(fileSystem, this.consistencyGuardConfig) : new NoOpConsistencyGuard());
        }
        return this.fs;
    }

    public FileSystem getRawFs() {
        return this.getFs().getFileSystem();
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf.get();
    }

    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HoodieActiveTimeline(this);
        }
        return this.activeTimeline;
    }

    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = new HoodieActiveTimeline(this);
        return this.activeTimeline;
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public synchronized HoodieArchivedTimeline getArchivedTimeline() {
        if (this.archivedTimeline == null) {
            this.archivedTimeline = new HoodieArchivedTimeline(this);
        }
        return this.archivedTimeline;
    }

    public static HoodieTableMetaClient initTableAndGetMetaClient(Configuration hadoopConf, String basePath, Properties props) throws IOException {
        Path auxiliaryFolder;
        Path temporaryFolder;
        Path archiveLogDir;
        String archiveLogPropVal;
        Path metaPathDir;
        LOG.info((Object)("Initializing " + basePath + " as hoodie table " + basePath));
        Path basePathDir = new Path(basePath);
        FileSystem fs = FSUtils.getFs(basePath, hadoopConf);
        if (!fs.exists(basePathDir)) {
            fs.mkdirs(basePathDir);
        }
        if (!fs.exists(metaPathDir = new Path(basePath, METAFOLDER_NAME))) {
            fs.mkdirs(metaPathDir);
        }
        if (!(archiveLogPropVal = props.getProperty("hoodie.archivelog.folder", "")).equals("") && !fs.exists(archiveLogDir = new Path(metaPathDir, archiveLogPropVal))) {
            fs.mkdirs(archiveLogDir);
        }
        if (!fs.exists(temporaryFolder = new Path(basePath, TEMPFOLDER_NAME))) {
            fs.mkdirs(temporaryFolder);
        }
        if (!fs.exists(auxiliaryFolder = new Path(basePath, AUXILIARYFOLDER_NAME))) {
            fs.mkdirs(auxiliaryFolder);
        }
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(hadoopConf, basePath, fs);
        HoodieTableConfig.createHoodieProperties(fs, metaPathDir, props);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(hadoopConf).setBasePath(basePath).build();
        LOG.info((Object)("Finished initializing Table of type " + (Object)((Object)metaClient.getTableConfig().getTableType()) + " from " + basePath));
        return metaClient;
    }

    public static void initializeBootstrapDirsIfNotExists(Configuration hadoopConf, String basePath, FileSystem fs) throws IOException {
        Path bootstrap_index_folder_by_fileids;
        Path bootstrap_index_folder_by_partition = new Path(basePath, BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH);
        if (!fs.exists(bootstrap_index_folder_by_partition)) {
            fs.mkdirs(bootstrap_index_folder_by_partition);
        }
        if (!fs.exists(bootstrap_index_folder_by_fileids = new Path(basePath, BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH))) {
            fs.mkdirs(bootstrap_index_folder_by_fileids);
        }
    }

    public static FileStatus[] scanFiles(FileSystem fs, Path metaPath, PathFilter nameFilter) throws IOException {
        return fs.listStatus(metaPath, nameFilter);
    }

    public HoodieTimeline getCommitsTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitsTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitsAndCompactionTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getWriteTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: 
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType(this.getTableType());
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        return this.scanHoodieInstantsFromFileSystem(new Path(this.metaPath), includedExtensions, applyLayoutVersionFilters);
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Path timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        Stream<HoodieInstant> instantStream = Arrays.stream(HoodieTableMetaClient.scanFiles(this.getFs(), timelinePath, path -> {
            String extension = HoodieInstant.getTimelineFileExtension(path.getName());
            return includedExtensions.contains(extension);
        })).map(HoodieInstant::new);
        if (applyLayoutVersionFilters) {
            instantStream = TimelineLayout.getLayout(this.getTimelineLayoutVersion()).filterHoodieInstants(instantStream);
        }
        return instantStream.sorted().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieTableMetaClient that = (HoodieTableMetaClient)o;
        return Objects.equals(this.basePath, that.basePath) && this.tableType == that.tableType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basePath, this.tableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieTableMetaClient{");
        sb.append("basePath='").append(this.basePath).append('\'');
        sb.append(", metaPath='").append(this.metaPath).append('\'');
        sb.append(", tableType=").append((Object)this.tableType);
        sb.append('}');
        return sb.toString();
    }

    public void initializeBootstrapDirsIfNotExists() throws IOException {
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(this.getHadoopConf(), this.basePath, this.getFs());
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setMetaPath(String metaPath) {
        this.metaPath = metaPath;
    }

    public void setActiveTimeline(HoodieActiveTimeline activeTimeline) {
        this.activeTimeline = activeTimeline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PropertyBuilder withPropertyBuilder() {
        return new PropertyBuilder();
    }

    public static class PropertyBuilder {
        private HoodieTableType tableType;
        private String tableName;
        private String archiveLogFolder;
        private String payloadClassName;
        private Integer timelineLayoutVersion;
        private String baseFileFormat;
        private String preCombineField;
        private String bootstrapIndexClass;
        private String bootstrapBasePath;

        private PropertyBuilder() {
        }

        public PropertyBuilder setTableType(HoodieTableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public PropertyBuilder setTableType(String tableType) {
            return this.setTableType(HoodieTableType.valueOf(tableType));
        }

        public PropertyBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public PropertyBuilder setArchiveLogFolder(String archiveLogFolder) {
            this.archiveLogFolder = archiveLogFolder;
            return this;
        }

        public PropertyBuilder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public PropertyBuilder setPayloadClass(Class<? extends HoodieRecordPayload> payloadClass) {
            return this.setPayloadClassName(payloadClass.getName());
        }

        public PropertyBuilder setTimelineLayoutVersion(Integer timelineLayoutVersion) {
            this.timelineLayoutVersion = timelineLayoutVersion;
            return this;
        }

        public PropertyBuilder setBaseFileFormat(String baseFileFormat) {
            this.baseFileFormat = baseFileFormat;
            return this;
        }

        public PropertyBuilder setPreCombineField(String preCombineField) {
            this.preCombineField = preCombineField;
            return this;
        }

        public PropertyBuilder setBootstrapIndexClass(String bootstrapIndexClass) {
            this.bootstrapIndexClass = bootstrapIndexClass;
            return this;
        }

        public PropertyBuilder setBootstrapBasePath(String bootstrapBasePath) {
            this.bootstrapBasePath = bootstrapBasePath;
            return this;
        }

        public PropertyBuilder fromMetaClient(HoodieTableMetaClient metaClient) {
            return this.setTableType(metaClient.getTableType()).setTableName(metaClient.getTableConfig().getTableName()).setArchiveLogFolder(metaClient.getArchivePath()).setPayloadClassName(metaClient.getTableConfig().getPayloadClass());
        }

        public PropertyBuilder fromProperties(Properties properties) {
            if (properties.containsKey("hoodie.table.name")) {
                this.setTableName(properties.getProperty("hoodie.table.name"));
            }
            if (properties.containsKey("hoodie.table.type")) {
                this.setTableType(properties.getProperty("hoodie.table.type"));
            }
            if (properties.containsKey("hoodie.archivelog.folder")) {
                this.setArchiveLogFolder(properties.getProperty("hoodie.archivelog.folder"));
            }
            if (properties.containsKey("hoodie.compaction.payload.class")) {
                this.setPayloadClassName(properties.getProperty("hoodie.compaction.payload.class"));
            }
            if (properties.containsKey("hoodie.timeline.layout.version")) {
                this.setTimelineLayoutVersion(Integer.parseInt(properties.getProperty("hoodie.timeline.layout.version")));
            }
            if (properties.containsKey("hoodie.table.base.file.format")) {
                this.setBaseFileFormat(properties.getProperty("hoodie.table.base.file.format"));
            }
            if (properties.containsKey("hoodie.bootstrap.index.class")) {
                this.setBootstrapIndexClass(properties.getProperty("hoodie.bootstrap.index.class"));
            }
            if (properties.containsKey("hoodie.bootstrap.base.path")) {
                this.setBootstrapBasePath(properties.getProperty("hoodie.bootstrap.base.path"));
            }
            if (properties.containsKey("hoodie.table.precombine.field")) {
                this.setPreCombineField(properties.getProperty("hoodie.table.precombine.field"));
            }
            return this;
        }

        public Properties build() {
            ValidationUtils.checkArgument(this.tableType != null, "tableType is null");
            ValidationUtils.checkArgument(this.tableName != null, "tableName is null");
            Properties properties = new Properties();
            properties.setProperty("hoodie.table.name", this.tableName);
            properties.setProperty("hoodie.table.type", this.tableType.name());
            properties.setProperty("hoodie.table.version", String.valueOf(HoodieTableVersion.current().versionCode()));
            if (this.tableType == HoodieTableType.MERGE_ON_READ && this.payloadClassName != null) {
                properties.setProperty("hoodie.compaction.payload.class", this.payloadClassName);
            }
            if (null != this.archiveLogFolder) {
                properties.put("hoodie.archivelog.folder", this.archiveLogFolder);
            }
            if (null != this.timelineLayoutVersion) {
                properties.put("hoodie.timeline.layout.version", String.valueOf(this.timelineLayoutVersion));
            }
            if (null != this.baseFileFormat) {
                properties.setProperty("hoodie.table.base.file.format", this.baseFileFormat.toUpperCase());
            }
            if (null != this.bootstrapIndexClass) {
                properties.put("hoodie.bootstrap.index.class", this.bootstrapIndexClass);
            }
            if (null != this.bootstrapBasePath) {
                properties.put("hoodie.bootstrap.base.path", this.bootstrapBasePath);
            }
            if (null != this.preCombineField) {
                properties.put("hoodie.table.precombine.field", this.preCombineField);
            }
            return properties;
        }

        public HoodieTableMetaClient initTable(Configuration configuration, String basePath) throws IOException {
            return HoodieTableMetaClient.initTableAndGetMetaClient(configuration, basePath, this.build());
        }
    }

    public static class Builder {
        private Configuration conf;
        private String basePath;
        private boolean loadActiveTimelineOnLoad = false;
        private String payloadClassName = null;
        private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        private Option<TimelineLayoutVersion> layoutVersion = Option.of(TimelineLayoutVersion.CURR_LAYOUT_VERSION);

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setLoadActiveTimelineOnLoad(boolean loadActiveTimelineOnLoad) {
            this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
            return this;
        }

        public Builder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public Builder setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.consistencyGuardConfig = consistencyGuardConfig;
            return this;
        }

        public Builder setLayoutVersion(Option<TimelineLayoutVersion> layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public HoodieTableMetaClient build() {
            ValidationUtils.checkArgument(this.conf != null, "Configuration needs to be set to init HoodieTableMetaClient");
            ValidationUtils.checkArgument(this.basePath != null, "basePath needs to be set to init HoodieTableMetaClient");
            return new HoodieTableMetaClient(this.conf, this.basePath, this.loadActiveTimelineOnLoad, this.consistencyGuardConfig, this.layoutVersion, this.payloadClassName);
        }
    }
}

