/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.RegionMergeCoordination;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.coordination.SplitTransactionCoordination;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.ZKSplitTransactionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkRegionMergeCoordination;
import org.apache.hadoop.hbase.coordination.ZkSplitLogWorkerCoordination;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ZkCoordinatedStateManager
extends BaseCoordinatedStateManager {
    private static final Log LOG = LogFactory.getLog(ZkCoordinatedStateManager.class);
    protected Server server;
    protected ZooKeeperWatcher watcher;
    protected SplitTransactionCoordination splitTransactionCoordination;
    protected CloseRegionCoordination closeRegionCoordination;
    protected SplitLogWorkerCoordination splitLogWorkerCoordination;
    protected SplitLogManagerCoordination splitLogManagerCoordination;
    protected OpenRegionCoordination openRegionCoordination;
    protected RegionMergeCoordination regionMergeCoordination;

    @Override
    public void initialize(Server server) {
        this.server = server;
        this.watcher = server.getZooKeeper();
        this.splitLogWorkerCoordination = new ZkSplitLogWorkerCoordination(this, this.watcher);
        this.splitLogManagerCoordination = new ZKSplitLogManagerCoordination(this, this.watcher);
        this.splitTransactionCoordination = new ZKSplitTransactionCoordination(this, this.watcher);
        this.closeRegionCoordination = new ZkCloseRegionCoordination(this, this.watcher);
        this.openRegionCoordination = new ZkOpenRegionCoordination(this, this.watcher);
        this.regionMergeCoordination = new ZkRegionMergeCoordination(this, this.watcher);
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public TableStateManager getTableStateManager() throws InterruptedException, CoordinatedStateException {
        try {
            return new ZKTableStateManager(this.server.getZooKeeper());
        }
        catch (KeeperException e) {
            throw new CoordinatedStateException(e);
        }
    }

    @Override
    public SplitLogWorkerCoordination getSplitLogWorkerCoordination() {
        return this.splitLogWorkerCoordination;
    }

    @Override
    public SplitLogManagerCoordination getSplitLogManagerCoordination() {
        return this.splitLogManagerCoordination;
    }

    @Override
    public SplitTransactionCoordination getSplitTransactionCoordination() {
        return this.splitTransactionCoordination;
    }

    @Override
    public CloseRegionCoordination getCloseRegionCoordination() {
        return this.closeRegionCoordination;
    }

    @Override
    public OpenRegionCoordination getOpenRegionCoordination() {
        return this.openRegionCoordination;
    }

    @Override
    public RegionMergeCoordination getRegionMergeCoordination() {
        return this.regionMergeCoordination;
    }
}

