/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MetricsRegion;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RowProcessor;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hudi.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Region
extends ConfigurationObserver {
    public HRegionInfo getRegionInfo();

    public HTableDescriptor getTableDesc();

    public boolean isAvailable();

    public boolean isClosed();

    public boolean isClosing();

    public boolean isRecovering();

    public boolean isReadOnly();

    public List<Store> getStores();

    public Store getStore(byte[] var1);

    public List<String> getStoreFileList(byte[][] var1);

    public boolean refreshStoreFiles() throws IOException;

    public long getOpenSeqNum();

    public long getMaxFlushedSeqId();

    @Deprecated
    @VisibleForTesting
    public long getOldestSeqIdOfStore(byte[] var1);

    public long getOldestHfileTs(boolean var1) throws IOException;

    public Map<byte[], Long> getMaxStoreSeqId();

    public boolean isLoadingCfsOnDemandDefault();

    public long getReadpoint(IsolationLevel var1);

    public long getEarliestFlushTimeForAllStores();

    public long getReadRequestsCount();

    public void updateReadRequestsCount(long var1);

    public long getWriteRequestsCount();

    public void updateWriteRequestsCount(long var1);

    public long getMemstoreSize();

    public long getNumMutationsWithoutWAL();

    public long getDataInMemoryWithoutWAL();

    public long getBlockedRequestsCount();

    public long getCheckAndMutateChecksPassed();

    public long getCheckAndMutateChecksFailed();

    public MetricsRegion getMetrics();

    public HDFSBlocksDistribution getHDFSBlocksDistribution();

    public void startRegionOperation() throws IOException;

    public void startRegionOperation(Operation var1) throws IOException;

    public void closeRegionOperation() throws IOException;

    public RowLock getRowLock(byte[] var1, boolean var2) throws IOException;

    public void releaseRowLocks(List<RowLock> var1);

    public Result append(Append var1, long var2, long var4) throws IOException;

    public OperationStatus[] batchMutate(Mutation[] var1, long var2, long var4) throws IOException;

    public OperationStatus[] batchReplay(WALSplitter.MutationReplay[] var1, long var2) throws IOException;

    public boolean checkAndMutate(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, ByteArrayComparable var5, Mutation var6, boolean var7) throws IOException;

    public boolean checkAndRowMutate(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, ByteArrayComparable var5, RowMutations var6, boolean var7) throws IOException;

    public void delete(Delete var1) throws IOException;

    public Result get(Get var1) throws IOException;

    public List<Cell> get(Get var1, boolean var2) throws IOException;

    public Result getClosestRowBefore(byte[] var1, byte[] var2) throws IOException;

    public RegionScanner getScanner(Scan var1) throws IOException;

    public RegionScanner getScanner(Scan var1, List<KeyValueScanner> var2) throws IOException;

    public Result increment(Increment var1, long var2, long var4) throws IOException;

    public void mutateRow(RowMutations var1) throws IOException;

    public void mutateRowsWithLocks(Collection<Mutation> var1, Collection<byte[]> var2, long var3, long var5) throws IOException;

    public void processRowsWithLocks(RowProcessor<?, ?> var1) throws IOException;

    public void processRowsWithLocks(RowProcessor<?, ?> var1, long var2, long var4) throws IOException;

    public void processRowsWithLocks(RowProcessor<?, ?> var1, long var2, long var4, long var6) throws IOException;

    public void put(Put var1) throws IOException;

    public boolean bulkLoadHFiles(Collection<Pair<byte[], String>> var1, boolean var2, BulkLoadListener var3) throws IOException;

    public RegionCoprocessorHost getCoprocessorHost();

    public Message execService(RpcController var1, ClientProtos.CoprocessorServiceCall var2) throws IOException;

    public boolean registerService(Service var1);

    public void checkFamilies(Collection<byte[]> var1) throws NoSuchColumnFamilyException;

    public void checkTimestamps(Map<byte[], List<Cell>> var1, long var2) throws FailedSanityCheckException;

    public void prepareDelete(Delete var1) throws IOException;

    public void prepareDeleteTimestamps(Mutation var1, Map<byte[], List<Cell>> var2, byte[] var3) throws IOException;

    public void updateCellTimestamps(Iterable<List<Cell>> var1, byte[] var2) throws IOException;

    public FlushResult flush(boolean var1) throws IOException;

    public void compact(boolean var1) throws IOException;

    public void triggerMajorCompaction() throws IOException;

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState();

    public void waitForFlushesAndCompactions();

    public static interface FlushResult {
        public Result getResult();

        public boolean isFlushSucceeded();

        public boolean isCompactionNeeded();

        public static enum Result {
            FLUSHED_NO_COMPACTION_NEEDED,
            FLUSHED_COMPACTION_NEEDED,
            CANNOT_FLUSH_MEMSTORE_EMPTY,
            CANNOT_FLUSH;

        }
    }

    public static interface BulkLoadListener {
        public String prepareBulkLoad(byte[] var1, String var2) throws IOException;

        public void doneBulkLoad(byte[] var1, String var2) throws IOException;

        public void failedBulkLoad(byte[] var1, String var2) throws IOException;
    }

    public static interface RowLock {
        public void release();
    }

    public static enum Operation {
        ANY,
        GET,
        PUT,
        DELETE,
        SCAN,
        APPEND,
        INCREMENT,
        SPLIT_REGION,
        MERGE_REGION,
        BATCH_MUTATE,
        REPLAY_BATCH_MUTATE,
        COMPACT_REGION,
        REPLAY_EVENT;

    }
}

