/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hudi.com.google.common.collect.Sets;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSHDFSUtils
extends FSUtils {
    private static final Log LOG = LogFactory.getLog(FSHDFSUtils.class);
    private static Class dfsUtilClazz;
    private static Method getNNAddressesMethod;

    private static Set<InetSocketAddress> getNNAddresses(DistributedFileSystem fs, Configuration conf) {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        String serviceName = fs.getCanonicalServiceName();
        if (serviceName.startsWith("ha-hdfs")) {
            try {
                if (dfsUtilClazz == null) {
                    dfsUtilClazz = Class.forName("org.apache.hadoop.hdfs.DFSUtil");
                }
                if (getNNAddressesMethod == null) {
                    try {
                        getNNAddressesMethod = dfsUtilClazz.getMethod("getNNServiceRpcAddressesForCluster", Configuration.class);
                    }
                    catch (NoSuchMethodException e) {
                        getNNAddressesMethod = dfsUtilClazz.getMethod("getNNServiceRpcAddresses", Configuration.class);
                    }
                }
                Map addressMap = (Map)getNNAddressesMethod.invoke(null, conf);
                for (Map.Entry entry : addressMap.entrySet()) {
                    Map nnMap = (Map)entry.getValue();
                    for (Map.Entry e2 : nnMap.entrySet()) {
                        InetSocketAddress addr = (InetSocketAddress)e2.getValue();
                        addresses.add(addr);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("DFSUtil.getNNServiceRpcAddresses failed. serviceName=" + serviceName), (Throwable)e);
            }
        } else {
            URI uri = fs.getUri();
            int port = uri.getPort();
            if (port < 0) {
                int idx = serviceName.indexOf(58);
                port = Integer.parseInt(serviceName.substring(idx + 1));
            }
            InetSocketAddress addr = new InetSocketAddress(uri.getHost(), port);
            addresses.add(addr);
        }
        return addresses;
    }

    public static boolean isSameHdfs(Configuration conf, FileSystem srcFs, FileSystem desFs) {
        Set<InetSocketAddress> desAddrs;
        Set<InetSocketAddress> srcAddrs;
        Collection internalNameServices;
        String srcServiceName = srcFs.getCanonicalServiceName();
        String desServiceName = desFs.getCanonicalServiceName();
        if (srcServiceName == null || desServiceName == null) {
            return false;
        }
        if (srcServiceName.equals(desServiceName)) {
            return true;
        }
        if (srcServiceName.startsWith("ha-hdfs") && desServiceName.startsWith("ha-hdfs") && !(internalNameServices = conf.getTrimmedStringCollection("dfs.internal.nameservices")).isEmpty()) {
            return internalNameServices.contains(srcServiceName.split(":")[1]);
        }
        return srcFs instanceof DistributedFileSystem && desFs instanceof DistributedFileSystem && Sets.intersection(srcAddrs = FSHDFSUtils.getNNAddresses((DistributedFileSystem)srcFs, conf), desAddrs = FSHDFSUtils.getNNAddresses((DistributedFileSystem)desFs, conf)).size() > 0;
    }

    @Override
    public void recoverFileLease(FileSystem fs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        this.recoverDFSFileLease((DistributedFileSystem)fs, p, conf, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        LOG.info((Object)("Recover lease on dfs file " + p));
        long startWaiting = EnvironmentEdgeManager.currentTime();
        long recoveryTimeout = (long)conf.getInt("hbase.lease.recovery.timeout", 900000) + startWaiting;
        long firstPause = conf.getInt("hbase.lease.recovery.first.pause", 4000);
        long subsequentPauseBase = conf.getLong("hbase.lease.recovery.dfs.timeout", 61000L);
        Method isFileClosedMeth = null;
        boolean findIsFileClosedMeth = true;
        boolean recovered = false;
        int nbAttempt = 0;
        while (!recovered && !(recovered = this.recoverLease(dfs, nbAttempt, p, startWaiting))) {
            block12: {
                this.checkIfCancelled(reporter);
                if (this.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting)) break;
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block12;
                    }
                    long localStartWaiting = EnvironmentEdgeManager.currentTime();
                    while (EnvironmentEdgeManager.currentTime() - localStartWaiting < subsequentPauseBase * (long)nbAttempt) {
                        Thread.sleep(conf.getInt("hbase.lease.recovery.pause", 1000));
                        if (findIsFileClosedMeth) {
                            try {
                                isFileClosedMeth = dfs.getClass().getMethod("isFileClosed", Path.class);
                            }
                            catch (NoSuchMethodException nsme) {
                                LOG.debug((Object)"isFileClosed not available");
                            }
                            finally {
                                findIsFileClosedMeth = false;
                            }
                        }
                        if (isFileClosedMeth != null && this.isFileClosed(dfs, isFileClosedMeth, p)) {
                            recovered = true;
                            break;
                        }
                        this.checkIfCancelled(reporter);
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        return recovered;
    }

    boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < EnvironmentEdgeManager.currentTime()) {
            LOG.warn((Object)("Cannot recoverLease after trying for " + conf.getInt("hbase.lease.recovery.timeout", 900000) + "ms (hbase.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + this.getLogMessageDetail(nbAttempt, p, startWaiting)));
            return true;
        }
        return false;
    }

    boolean recoverLease(DistributedFileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = dfs.recoverLease(p);
            LOG.info((Object)((recovered ? "Recovered lease, " : "Failed to recover lease, ") + this.getLogMessageDetail(nbAttempt, p, startWaiting)));
        }
        catch (IOException e) {
            if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given WAL wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            LOG.warn((Object)this.getLogMessageDetail(nbAttempt, p, startWaiting), (Throwable)e);
        }
        return recovered;
    }

    private String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms";
    }

    private boolean isFileClosed(DistributedFileSystem dfs, Method m, Path p) {
        try {
            return (Boolean)m.invoke((Object)dfs, p);
        }
        catch (SecurityException e) {
            LOG.warn((Object)"No access", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed invocation for " + p.toString()), (Throwable)e);
        }
        return false;
    }

    void checkIfCancelled(CancelableProgressable reporter) throws InterruptedIOException {
        if (reporter == null) {
            return;
        }
        if (!reporter.progress()) {
            throw new InterruptedIOException("Operation cancelled");
        }
    }
}

