/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.HashMap;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public class HoodieAvroWriteSupport
extends AvroWriteSupport {
    private Option<BloomFilter> bloomFilterOpt;
    private String minRecordKey;
    private String maxRecordKey;
    public static final String OLD_HOODIE_AVRO_BLOOM_FILTER_METADATA_KEY = "com.uber.hoodie.bloomfilter";
    public static final String HOODIE_AVRO_BLOOM_FILTER_METADATA_KEY = "org.apache.hudi.bloomfilter";
    public static final String HOODIE_MIN_RECORD_KEY_FOOTER = "hoodie_min_record_key";
    public static final String HOODIE_MAX_RECORD_KEY_FOOTER = "hoodie_max_record_key";
    public static final String HOODIE_BLOOM_FILTER_TYPE_CODE = "hoodie_bloom_filter_type_code";
    public static final String HOODIE_AVRO_SCHEMA_METADATA_KEY = "orc.avro.schema";

    public HoodieAvroWriteSupport(MessageType schema, Schema avroSchema, Option<BloomFilter> bloomFilterOpt) {
        super(schema, avroSchema);
        this.bloomFilterOpt = bloomFilterOpt;
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        if (this.bloomFilterOpt.isPresent()) {
            extraMetaData.put(HOODIE_AVRO_BLOOM_FILTER_METADATA_KEY, this.bloomFilterOpt.get().serializeToString());
            if (this.minRecordKey != null && this.maxRecordKey != null) {
                extraMetaData.put(HOODIE_MIN_RECORD_KEY_FOOTER, this.minRecordKey);
                extraMetaData.put(HOODIE_MAX_RECORD_KEY_FOOTER, this.maxRecordKey);
            }
            if (this.bloomFilterOpt.get().getBloomFilterTypeCode().name().contains("DYNAMIC")) {
                extraMetaData.put(HOODIE_BLOOM_FILTER_TYPE_CODE, this.bloomFilterOpt.get().getBloomFilterTypeCode().name());
            }
        }
        return new WriteSupport.FinalizedWriteContext(extraMetaData);
    }

    public void add(String recordKey) {
        if (this.bloomFilterOpt.isPresent()) {
            this.bloomFilterOpt.get().add(recordKey);
            this.minRecordKey = this.minRecordKey != null ? (this.minRecordKey.compareTo(recordKey) <= 0 ? this.minRecordKey : recordKey) : recordKey;
            this.maxRecordKey = this.maxRecordKey != null ? (this.maxRecordKey.compareTo(recordKey) >= 0 ? this.maxRecordKey : recordKey) : recordKey;
        }
    }
}

