/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;

public class HoodieCommonConfig
extends HoodieConfig {
    public static final ConfigProperty<ExternalSpillableMap.DiskMapType> SPILLABLE_DISK_MAP_TYPE = ConfigProperty.key("hoodie.common.spillable.diskmap.type").defaultValue(ExternalSpillableMap.DiskMapType.BITCASK).withDocumentation("When handling input data that cannot be held in memory, to merge with a file on storage, a spillable diskmap is employed.  By default, we use a persistent hashmap based loosely on bitcask, that offers O(1) inserts, lookups. Change this to `ROCKS_DB` to prefer using rocksDB, for handling the spill.");
    public static final ConfigProperty<Boolean> DISK_MAP_BITCASK_COMPRESSION_ENABLED = ConfigProperty.key("hoodie.common.diskmap.compression.enabled").defaultValue(true).withDocumentation("Turn on compression for BITCASK disk map used by the External Spillable Map");

    public ExternalSpillableMap.DiskMapType getSpillableDiskMapType() {
        return ExternalSpillableMap.DiskMapType.valueOf(this.getString(SPILLABLE_DISK_MAP_TYPE).toUpperCase(Locale.ROOT));
    }

    public boolean isBitCaskDiskMapCompressionEnabled() {
        return this.getBoolean(DISK_MAP_BITCASK_COMPRESSION_ENABLED);
    }

    private HoodieCommonConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieCommonConfig commonConfig = new HoodieCommonConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.commonConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.commonConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withSpillableDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.commonConfig.setValue(SPILLABLE_DISK_MAP_TYPE, diskMapType.name());
            return this;
        }

        public Builder withBitcaskDiskMapCompressionEnabled(boolean bitcaskDiskMapCompressionEnabled) {
            this.commonConfig.setValue(DISK_MAP_BITCASK_COMPRESSION_ENABLED, String.valueOf(bitcaskDiskMapCompressionEnabled));
            return this;
        }

        public HoodieCommonConfig build() {
            this.commonConfig.setDefaults(HoodieCommonConfig.class.getName());
            return this.commonConfig;
        }
    }
}

