/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class OverwriteWithLatestAvroPayload
extends BaseAvroPayload
implements HoodieRecordPayload<OverwriteWithLatestAvroPayload> {
    public OverwriteWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteWithLatestAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord indexedRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        if (this.isDeleteRecord(indexedRecord)) {
            return Option.empty();
        }
        return Option.of(indexedRecord);
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord) {
        String isDeleteKey = "_hoodie_is_deleted";
        if (genericRecord.getSchema().getField("_hoodie_is_deleted") == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get("_hoodie_is_deleted");
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }

    public Boolean overwriteField(Object value, Object defaultValue) {
        return defaultValue == null ? value == null : defaultValue.equals(value);
    }
}

