/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.bootstrap.index.NoOpBootstrapIndex;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@ConfigClassProperty(name="Table Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that persist across writes and read on a Hudi table  like  base, log file formats, table name, creation schema, table version layouts.  Configurations are loaded from hoodie.properties, these properties are usually set during initializing a path as hoodie base path and rarely changes during the lifetime of the table. Writers/Queries' configurations are validated against these  each time for compatibility.")
public class HoodieTableConfig
extends HoodieConfig
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieTableConfig.class);
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final ConfigProperty<String> NAME = ConfigProperty.key("hoodie.table.name").noDefaultValue().withDocumentation("Table name that will be used for registering with Hive. Needs to be same across runs.");
    public static final ConfigProperty<HoodieTableType> TYPE = ConfigProperty.key("hoodie.table.type").defaultValue(HoodieTableType.COPY_ON_WRITE).withDocumentation("The table type for the underlying data, for this write. This can\u2019t change between writes.");
    public static final ConfigProperty<HoodieTableVersion> VERSION = ConfigProperty.key("hoodie.table.version").defaultValue(HoodieTableVersion.ZERO).withDocumentation("Version of table, used for running upgrade/downgrade steps between releases with potentially breaking/backwards compatible changes.");
    public static final ConfigProperty<String> PRECOMBINE_FIELD = ConfigProperty.key("hoodie.table.precombine.field").noDefaultValue().withDocumentation("Field used in preCombining before actual write. By default, when two records have the same key value, the largest value for the precombine field determined by Object.compareTo(..), is picked.");
    public static final ConfigProperty<String> PARTITION_FIELDS = ConfigProperty.key("hoodie.table.partition.fields").noDefaultValue().withDocumentation("Fields used to partition the table. Concatenated values of these fields are used as the partition path, by invoking toString()");
    public static final ConfigProperty<String> RECORDKEY_FIELDS = ConfigProperty.key("hoodie.table.recordkey.fields").noDefaultValue().withDocumentation("Columns used to uniquely identify the table. Concatenated values of these fields are used as  the record key component of HoodieKey.");
    public static final ConfigProperty<String> CREATE_SCHEMA = ConfigProperty.key("hoodie.table.create.schema").noDefaultValue().withDocumentation("Schema used when creating the table, for the first time.");
    public static final ConfigProperty<HoodieFileFormat> BASE_FILE_FORMAT = ConfigProperty.key("hoodie.table.base.file.format").defaultValue(HoodieFileFormat.PARQUET).withAlternatives("hoodie.table.ro.file.format").withDocumentation("Base file format to store all the base file data.");
    public static final ConfigProperty<HoodieFileFormat> LOG_FILE_FORMAT = ConfigProperty.key("hoodie.table.log.file.format").defaultValue(HoodieFileFormat.HOODIE_LOG).withAlternatives("hoodie.table.rt.file.format").withDocumentation("Log format used for the delta logs.");
    public static final ConfigProperty<String> TIMELINE_LAYOUT_VERSION = ConfigProperty.key("hoodie.timeline.layout.version").noDefaultValue().withDocumentation("Version of timeline used, by the table.");
    public static final ConfigProperty<String> PAYLOAD_CLASS_NAME = ConfigProperty.key("hoodie.compaction.payload.class").defaultValue(OverwriteWithLatestAvroPayload.class.getName()).withDocumentation("Payload class to use for performing compactions, i.e merge delta logs with current base file and then  produce a new base file.");
    public static final ConfigProperty<String> ARCHIVELOG_FOLDER = ConfigProperty.key("hoodie.archivelog.folder").defaultValue("archived").withDocumentation("path under the meta folder, to store archived timeline instants at.");
    public static final ConfigProperty<String> BOOTSTRAP_INDEX_ENABLE = ConfigProperty.key("hoodie.bootstrap.index.enable").noDefaultValue().withDocumentation("Whether or not, this is a bootstrapped table, with bootstrap base data and an mapping index defined.");
    public static final ConfigProperty<String> BOOTSTRAP_INDEX_CLASS_NAME = ConfigProperty.key("hoodie.bootstrap.index.class").defaultValue(HFileBootstrapIndex.class.getName()).withDocumentation("Implementation to use, for mapping base files to bootstrap base file, that contain actual data.");
    public static final ConfigProperty<String> BOOTSTRAP_BASE_PATH = ConfigProperty.key("hoodie.bootstrap.base.path").noDefaultValue().withDocumentation("Base path of the dataset that needs to be bootstrapped as a Hudi table");
    public static final ConfigProperty<String> POPULATE_META_FIELDS = ConfigProperty.key("hoodie.populate.meta.fields").defaultValue("true").withDocumentation("When enabled, populates all meta fields. When disabled, no meta fields are populated and incremental queries will not be functional. This is only meant to be used for append only/immutable data for batch processing");
    public static final ConfigProperty<String> KEY_GENERATOR_CLASS_NAME = ConfigProperty.key("hoodie.table.keygenerator.class").noDefaultValue().withDocumentation("Key Generator class property for the hoodie table");
    public static final String NO_OP_BOOTSTRAP_INDEX_CLASS = NoOpBootstrapIndex.class.getName();
    @Deprecated
    public static final String HOODIE_RO_FILE_FORMAT_PROP_NAME = "hoodie.table.ro.file.format";
    @Deprecated
    public static final String HOODIE_RT_FILE_FORMAT_PROP_NAME = "hoodie.table.rt.file.format";
    @Deprecated
    public static final String HOODIE_TABLE_NAME_PROP_NAME = NAME.key();
    @Deprecated
    public static final String HOODIE_TABLE_TYPE_PROP_NAME = TYPE.key();
    @Deprecated
    public static final String HOODIE_TABLE_VERSION_PROP_NAME = VERSION.key();
    @Deprecated
    public static final String HOODIE_TABLE_PRECOMBINE_FIELD = PRECOMBINE_FIELD.key();
    @Deprecated
    public static final String HOODIE_BASE_FILE_FORMAT_PROP_NAME = BASE_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_LOG_FILE_FORMAT_PROP_NAME = LOG_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_TIMELINE_LAYOUT_VERSION = TIMELINE_LAYOUT_VERSION.key();
    @Deprecated
    public static final String HOODIE_PAYLOAD_CLASS_PROP_NAME = PAYLOAD_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_ARCHIVELOG_FOLDER_PROP_NAME = ARCHIVELOG_FOLDER.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME = BOOTSTRAP_INDEX_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_BASE_PATH = BOOTSTRAP_BASE_PATH.key();
    @Deprecated
    public static final HoodieTableType DEFAULT_TABLE_TYPE = TYPE.defaultValue();
    @Deprecated
    public static final HoodieTableVersion DEFAULT_TABLE_VERSION = VERSION.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_BASE_FILE_FORMAT = BASE_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_LOG_FILE_FORMAT = LOG_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final String DEFAULT_PAYLOAD_CLASS = PAYLOAD_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = BOOTSTRAP_INDEX_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_ARCHIVELOG_FOLDER = ARCHIVELOG_FOLDER.defaultValue();

    public HoodieTableConfig(FileSystem fs, String metaPath, String payloadClassName) {
        block27: {
            Path propertyPath = new Path(metaPath, HOODIE_PROPERTIES_FILE);
            LOG.info((Object)("Loading table properties from " + propertyPath));
            try {
                try (FSDataInputStream inputStream = fs.open(propertyPath);){
                    this.props.load((InputStream)inputStream);
                }
                if (!this.contains(PAYLOAD_CLASS_NAME) || payloadClassName == null || this.getString(PAYLOAD_CLASS_NAME).equals(payloadClassName)) break block27;
                this.setValue(PAYLOAD_CLASS_NAME, payloadClassName);
                var6_7 = null;
                try (FSDataOutputStream outputStream = fs.create(propertyPath);){
                    this.props.store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
                }
                catch (Throwable throwable) {
                    var6_7 = throwable;
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Could not load Hoodie properties from " + propertyPath, e);
            }
        }
        ValidationUtils.checkArgument(this.contains(TYPE) && this.contains(NAME), "hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
    }

    public HoodieTableConfig() {
    }

    public static void createHoodieProperties(FileSystem fs, Path metadataFolder, Properties properties) throws IOException {
        if (!fs.exists(metadataFolder)) {
            fs.mkdirs(metadataFolder);
        }
        HoodieConfig hoodieConfig = new HoodieConfig(properties);
        Path propertyPath = new Path(metadataFolder, HOODIE_PROPERTIES_FILE);
        try (FSDataOutputStream outputStream = fs.create(propertyPath);){
            if (!hoodieConfig.contains(NAME)) {
                throw new IllegalArgumentException(NAME.key() + " property needs to be specified");
            }
            hoodieConfig.setDefaultValue(TYPE);
            if (hoodieConfig.getString(TYPE).equals(HoodieTableType.MERGE_ON_READ.name())) {
                hoodieConfig.setDefaultValue(PAYLOAD_CLASS_NAME);
            }
            hoodieConfig.setDefaultValue(ARCHIVELOG_FOLDER);
            if (!hoodieConfig.contains(TIMELINE_LAYOUT_VERSION)) {
                hoodieConfig.setValue(TIMELINE_LAYOUT_VERSION, TimelineLayoutVersion.CURR_VERSION.toString());
            }
            if (hoodieConfig.contains(BOOTSTRAP_BASE_PATH)) {
                hoodieConfig.setDefaultValue(BOOTSTRAP_INDEX_CLASS_NAME, HoodieTableConfig.getDefaultBootstrapIndexClass(properties));
            }
            hoodieConfig.getProps().store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
        }
    }

    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.getStringOrDefault(TYPE));
    }

    public Option<TimelineLayoutVersion> getTimelineLayoutVersion() {
        return this.contains(TIMELINE_LAYOUT_VERSION) ? Option.of(new TimelineLayoutVersion(this.getInt(TIMELINE_LAYOUT_VERSION))) : Option.empty();
    }

    public HoodieTableVersion getTableVersion() {
        return this.contains(VERSION) ? HoodieTableVersion.versionFromCode(this.getInt(VERSION)) : VERSION.defaultValue();
    }

    public void setTableVersion(HoodieTableVersion tableVersion) {
        this.setValue(VERSION, Integer.toString(tableVersion.versionCode()));
    }

    public String getPayloadClass() {
        return this.getStringOrDefault(PAYLOAD_CLASS_NAME).replace("com.uber.hoodie", "org.apache.hudi");
    }

    public String getPreCombineField() {
        return this.getString(PRECOMBINE_FIELD);
    }

    public Option<String[]> getRecordKeyFields() {
        if (this.contains(RECORDKEY_FIELDS)) {
            return Option.of(Arrays.stream(this.getString(RECORDKEY_FIELDS).split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0]));
        }
        return Option.empty();
    }

    public Option<String[]> getPartitionFields() {
        if (this.contains(PARTITION_FIELDS)) {
            return Option.of(Arrays.stream(this.getString(PARTITION_FIELDS).split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0]));
        }
        return Option.empty();
    }

    public String getPartitionFieldProp() {
        return this.getString(PARTITION_FIELDS);
    }

    public String getBootstrapIndexClass() {
        return this.getStringOrDefault(BOOTSTRAP_INDEX_CLASS_NAME, HoodieTableConfig.getDefaultBootstrapIndexClass(this.props));
    }

    public static String getDefaultBootstrapIndexClass(Properties props) {
        String defaultClass = BOOTSTRAP_INDEX_CLASS_NAME.defaultValue();
        if ("false".equalsIgnoreCase(props.getProperty(BOOTSTRAP_INDEX_ENABLE.key()))) {
            defaultClass = NO_OP_BOOTSTRAP_INDEX_CLASS;
        }
        return defaultClass;
    }

    public Option<String> getBootstrapBasePath() {
        return Option.ofNullable(this.getString(BOOTSTRAP_BASE_PATH));
    }

    public Option<Schema> getTableCreateSchema() {
        if (this.contains(CREATE_SCHEMA)) {
            return Option.of(new Schema.Parser().parse(this.getString(CREATE_SCHEMA)));
        }
        return Option.empty();
    }

    public String getTableName() {
        return this.getString(NAME);
    }

    public HoodieFileFormat getBaseFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(BASE_FILE_FORMAT));
    }

    public HoodieFileFormat getLogFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(LOG_FILE_FORMAT));
    }

    public String getArchivelogFolder() {
        return this.getStringOrDefault(ARCHIVELOG_FOLDER);
    }

    public boolean populateMetaFields() {
        return Boolean.parseBoolean(this.getStringOrDefault(POPULATE_META_FIELDS));
    }

    public String getRecordKeyFieldProp() {
        return this.getString(RECORDKEY_FIELDS);
    }

    public Map<String, String> propsMap() {
        return this.props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }
}

