/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class HoodieFileSliceReader<T extends HoodieRecordPayload>
implements Iterator<HoodieRecord<T>> {
    private Iterator<HoodieRecord<T>> recordsIterator;

    public static <R extends IndexedRecord, T> HoodieFileSliceReader getFileSliceReader(HoodieFileReader<R> baseFileReader, HoodieMergedLogRecordScanner scanner, Schema schema, String payloadClass, String preCombineField, Option<Pair<String, String>> simpleKeyGenFieldsOpt) throws IOException {
        Iterator<R> baseIterator = baseFileReader.getRecordIterator(schema);
        while (baseIterator.hasNext()) {
            GenericRecord record = (GenericRecord)baseIterator.next();
            HoodieRecord hoodieRecord = simpleKeyGenFieldsOpt.isPresent() ? (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClass, preCombineField, simpleKeyGenFieldsOpt.get(), scanner.isWithOperationField()) : (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClass, preCombineField, scanner.isWithOperationField());
            scanner.processNextRecord(hoodieRecord);
        }
        return new HoodieFileSliceReader<T>(scanner.iterator());
    }

    private HoodieFileSliceReader(Iterator<HoodieRecord<T>> recordsItr) {
        this.recordsIterator = recordsItr;
    }

    @Override
    public boolean hasNext() {
        return this.recordsIterator.hasNext();
    }

    @Override
    public HoodieRecord<T> next() {
        return this.recordsIterator.next();
    }
}

