/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BootstrapBaseFileMapping;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractTableFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final Logger LOG = LogManager.getLogger(AbstractTableFileSystemView.class);
    protected HoodieTableMetaClient metaClient;
    private HoodieTimeline visibleCommitsAndCompactionTimeline;
    private final ConcurrentHashMap<String, Boolean> addedPartitions = new ConcurrentHashMap(4096);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.globalLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.globalLock.writeLock();
    private BootstrapIndex bootstrapIndex;

    private String getPartitionPathFromFilePath(String fullPath) {
        return FSUtils.getRelativePartitionPath(new Path(this.metaClient.getBasePath()), new Path(fullPath).getParent());
    }

    protected void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.metaClient = metaClient;
        this.refreshTimeline(visibleActiveTimeline);
        this.resetFileGroupsReplaced(this.visibleCommitsAndCompactionTimeline);
        this.bootstrapIndex = BootstrapIndex.getBootstrapIndex(metaClient);
        this.resetPendingCompactionOperations(CompactionUtils.getAllPendingCompactionOperations(metaClient).values().stream().map(e -> Pair.of(e.getKey(), CompactionOperation.convertFromAvroRecordInstance((HoodieCompactionOperation)e.getValue()))));
        this.resetBootstrapBaseFileMapping(Stream.empty());
        this.resetFileGroupsInPendingClustering(ClusteringUtils.getAllFileGroupsInPendingClusteringPlans(metaClient));
    }

    protected void refreshTimeline(HoodieTimeline visibleActiveTimeline) {
        this.visibleCommitsAndCompactionTimeline = visibleActiveTimeline.getWriteTimeline();
    }

    protected List<HoodieFileGroup> addFilesToView(FileStatus[] statuses) {
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<HoodieFileGroup> fileGroups = this.buildFileGroups(statuses, this.visibleCommitsAndCompactionTimeline, true);
        long fgBuildTimeTakenMs = timer.endTimer();
        timer.startTimer();
        fileGroups.stream().collect(Collectors.groupingBy(HoodieFileGroup::getPartitionPath)).forEach((partition, value) -> {
            if (!this.isPartitionAvailableInStore((String)partition)) {
                if (this.bootstrapIndex.useIndex()) {
                    try (BootstrapIndex.IndexReader reader = this.bootstrapIndex.createReader();){
                        LOG.info((Object)("Bootstrap Index available for partition " + partition));
                        List<BootstrapFileMapping> sourceFileMappings = reader.getSourceFileMappingForPartition((String)partition);
                        this.addBootstrapBaseFileMapping(sourceFileMappings.stream().map(s -> new BootstrapBaseFileMapping(new HoodieFileGroupId(s.getPartitionPath(), s.getFileId()), s.getBootstrapFileStatus())));
                    }
                }
                this.storePartitionView((String)partition, (List<HoodieFileGroup>)value);
            }
        });
        long storePartitionsTs = timer.endTimer();
        LOG.info((Object)("addFilesToView: NumFiles=" + statuses.length + ", NumFileGroups=" + fileGroups.size() + ", FileGroupsCreationTime=" + fgBuildTimeTakenMs + ", StoreTimeTaken=" + storePartitionsTs));
        return fileGroups;
    }

    protected List<HoodieFileGroup> buildFileGroups(FileStatus[] statuses, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        return this.buildFileGroups(this.convertFileStatusesToBaseFiles(statuses), this.convertFileStatusesToLogFiles(statuses), timeline, addPendingCompactionFileSlice);
    }

    protected List<HoodieFileGroup> buildFileGroups(Stream<HoodieBaseFile> baseFileStream, Stream<HoodieLogFile> logFileStream, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        Map<Pair, List<HoodieBaseFile>> baseFiles = baseFileStream.collect(Collectors.groupingBy(baseFile -> {
            String partitionPathStr = this.getPartitionPathFromFilePath(baseFile.getPath());
            return Pair.of(partitionPathStr, baseFile.getFileId());
        }));
        Map<Pair, List<HoodieLogFile>> logFiles = logFileStream.collect(Collectors.groupingBy(logFile -> {
            String partitionPathStr = FSUtils.getRelativePartitionPath(new Path(this.metaClient.getBasePath()), logFile.getPath().getParent());
            return Pair.of(partitionPathStr, logFile.getFileId());
        }));
        HashSet<Pair> fileIdSet = new HashSet<Pair>(baseFiles.keySet());
        fileIdSet.addAll(logFiles.keySet());
        ArrayList<HoodieFileGroup> fileGroups = new ArrayList<HoodieFileGroup>();
        fileIdSet.forEach(pair -> {
            Option<Pair<String, CompactionOperation>> pendingCompaction;
            String fileId = (String)pair.getValue();
            HoodieFileGroup group = new HoodieFileGroup((String)pair.getKey(), fileId, timeline);
            if (baseFiles.containsKey(pair)) {
                ((List)baseFiles.get(pair)).forEach(group::addBaseFile);
            }
            if (logFiles.containsKey(pair)) {
                ((List)logFiles.get(pair)).forEach(group::addLogFile);
            }
            if (addPendingCompactionFileSlice && (pendingCompaction = this.getPendingCompactionOperationWithInstant(group.getFileGroupId())).isPresent()) {
                group.addNewFileSliceAtInstant(pendingCompaction.get().getKey());
            }
            fileGroups.add(group);
        });
        return fileGroups;
    }

    private void resetFileGroupsReplaced(HoodieTimeline timeline) {
        HoodieTimer hoodieTimer = new HoodieTimer();
        hoodieTimer.startTimer();
        HoodieTimeline replacedTimeline = timeline.getCompletedReplaceTimeline();
        Stream<Map<HoodieFileGroupId, HoodieInstant>> resultStream = replacedTimeline.getInstants().flatMap(instant -> {
            try {
                HoodieReplaceCommitMetadata replaceMetadata = HoodieReplaceCommitMetadata.fromBytes(this.metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)instant).get(), HoodieReplaceCommitMetadata.class);
                return replaceMetadata.getPartitionToReplaceFileIds().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(e -> new AbstractMap.SimpleEntry<HoodieFileGroupId, HoodieInstant>(new HoodieFileGroupId((String)entry.getKey(), (String)e), (HoodieInstant)instant)));
            }
            catch (IOException e) {
                throw new HoodieIOException("error reading commit metadata for " + instant);
            }
        });
        Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups = resultStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.resetReplacedFileGroups(replacedFileGroups);
        LOG.info((Object)("Took " + hoodieTimer.endTimer() + " ms to read  " + replacedTimeline.countInstants() + " instants, " + replacedFileGroups.size() + " replaced file groups"));
    }

    @Override
    public final void reset() {
        try {
            this.writeLock.lock();
            this.addedPartitions.clear();
            this.resetViewState();
            this.bootstrapIndex = null;
            this.init(this.metaClient, this.getTimeline());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract void resetViewState();

    private void ensurePartitionLoadedCorrectly(String partition) {
        ValidationUtils.checkArgument(!this.isClosed(), "View is already closed");
        this.addedPartitions.computeIfAbsent(partition, this::lambda$ensurePartitionLoadedCorrectly$9);
    }

    protected FileStatus[] listPartition(Path partitionPath) throws IOException {
        return this.metaClient.getFs().listStatus(partitionPath);
    }

    private Stream<HoodieBaseFile> convertFileStatusesToBaseFiles(FileStatus[] statuses) {
        Predicate<FileStatus> roFilePredicate = fileStatus -> fileStatus.getPath().getName().contains(this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
        return Arrays.stream(statuses).filter(roFilePredicate).map(HoodieBaseFile::new);
    }

    private Stream<HoodieLogFile> convertFileStatusesToLogFiles(FileStatus[] statuses) {
        Predicate<FileStatus> rtFilePredicate = fileStatus -> fileStatus.getPath().getName().contains(this.metaClient.getTableConfig().getLogFileFormat().getFileExtension());
        return Arrays.stream(statuses).filter(rtFilePredicate).map(HoodieLogFile::new);
    }

    protected boolean isBaseFileDueToPendingCompaction(HoodieBaseFile baseFile) {
        String partitionPath = this.getPartitionPathFromFilePath(baseFile.getPath());
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(new HoodieFileGroupId(partitionPath, baseFile.getFileId()));
        return compactionWithInstantTime.isPresent() && null != compactionWithInstantTime.get().getKey() && baseFile.getCommitTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected boolean isFileSliceAfterPendingCompaction(FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
        LOG.info((Object)("Pending Compaction instant for (" + fileSlice + ") is :" + compactionWithInstantTime));
        return compactionWithInstantTime.isPresent() && fileSlice.getBaseInstantTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected FileSlice filterBaseFileAfterPendingCompaction(FileSlice fileSlice) {
        if (this.isFileSliceAfterPendingCompaction(fileSlice)) {
            LOG.info((Object)("File Slice (" + fileSlice + ") is in pending compaction"));
            FileSlice transformed = new FileSlice(fileSlice.getPartitionPath(), fileSlice.getBaseInstantTime(), fileSlice.getFileId());
            fileSlice.getLogFiles().forEach(transformed::addLogFile);
            return transformed;
        }
        return fileSlice;
    }

    protected HoodieFileGroup addBootstrapBaseFileIfPresent(HoodieFileGroup fileGroup) {
        boolean hasBootstrapBaseFile = fileGroup.getAllFileSlices().anyMatch(fs -> fs.getBaseInstantTime().equals("00000000000001"));
        if (hasBootstrapBaseFile) {
            HoodieFileGroup newFileGroup = new HoodieFileGroup(fileGroup);
            newFileGroup.getAllFileSlices().filter(fs -> fs.getBaseInstantTime().equals("00000000000001")).forEach(fs -> fs.setBaseFile(this.addBootstrapBaseFileIfPresent(fs.getFileGroupId(), fs.getBaseFile().get())));
            return newFileGroup;
        }
        return fileGroup;
    }

    protected FileSlice addBootstrapBaseFileIfPresent(FileSlice fileSlice) {
        if (fileSlice.getBaseInstantTime().equals("00000000000001")) {
            FileSlice copy = new FileSlice(fileSlice);
            copy.getBaseFile().ifPresent(dataFile -> {
                Option<BootstrapBaseFileMapping> edf = this.getBootstrapBaseFile(copy.getFileGroupId());
                edf.ifPresent(e -> dataFile.setBootstrapBaseFile(e.getBootstrapBaseFile()));
            });
            return copy;
        }
        return fileSlice;
    }

    protected HoodieBaseFile addBootstrapBaseFileIfPresent(HoodieFileGroupId fileGroupId, HoodieBaseFile baseFile) {
        if (baseFile.getCommitTime().equals("00000000000001")) {
            HoodieBaseFile copy = new HoodieBaseFile(baseFile);
            Option<BootstrapBaseFileMapping> edf = this.getBootstrapBaseFile(fileGroupId);
            edf.ifPresent(e -> copy.setBootstrapBaseFile(e.getBootstrapBaseFile()));
            return copy;
        }
        return baseFile;
    }

    @Override
    public final Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        try {
            this.readLock.lock();
            Stream<Pair<String, CompactionOperation>> stream = this.fetchPendingCompactionOperations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles(partitionPath).filter(df -> !this.isFileGroupReplaced(partitionPath, df.getFileId())).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles() {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionStr, String maxCommitTime) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchAllStoredFileGroups(partitionPath).filter(fileGroup -> !this.isFileGroupReplacedBeforeOrOn(fileGroup.getFileGroupId(), maxCommitTime)).map(fileGroup -> Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> HoodieTimeline.compareTimestamps(baseFile.getCommitTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, maxCommitTime)).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst())).filter(Option::isPresent).map(Option::get).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getBaseFileOn(String partitionStr, String instantTime, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplacedBeforeOrOn(new HoodieFileGroupId(partitionPath, fileId), instantTime)) {
                Option<HoodieBaseFile> option = Option.empty();
                return option;
            }
            Option<HoodieBaseFile> option = this.fetchHoodieFileGroup(partitionPath, fileId).map(fileGroup -> fileGroup.getAllBaseFiles().filter(baseFile -> HoodieTimeline.compareTimestamps(baseFile.getCommitTime(), HoodieTimeline.EQUALS, instantTime)).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst().orElse(null)).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, fileId), (HoodieBaseFile)df));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getLatestBaseFile(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplaced(partitionPath, fileId)) {
                Option<HoodieBaseFile> option = Option.empty();
                return option;
            }
            Option<HoodieBaseFile> option = this.fetchLatestBaseFile(partitionPath, fileId).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, fileId), (HoodieBaseFile)df));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchAllStoredFileGroups().filter(fileGroup -> !this.isFileGroupReplacedBeforeAny(fileGroup.getFileGroupId(), commitsToReturn)).map(fileGroup -> Pair.of(fileGroup.getFileGroupId(), Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> commitsToReturn.contains(baseFile.getCommitTime()) && !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)baseFile)).findFirst()))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getAllBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchAllBaseFiles(partitionPath).filter(df -> !this.isFileGroupReplaced(partitionPath, df.getFileId())).filter(df -> this.visibleCommitsAndCompactionTimeline.containsOrBeforeTimelineStarts(df.getCommitTime())).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).map(df -> this.addBootstrapBaseFileIfPresent(new HoodieFileGroupId(partitionPath, df.getFileId()), (HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchLatestFileSlices(partitionPath).filter(slice -> !this.isFileGroupReplaced(slice.getFileGroupId())).map(this::filterBaseFileAfterPendingCompaction).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<FileSlice> getLatestFileSlice(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            if (this.isFileGroupReplaced(partitionPath, fileId)) {
                Option<FileSlice> option = Option.empty();
                return option;
            }
            Option<FileSlice> fs = this.fetchLatestFileSlice(partitionPath, fileId);
            Option<FileSlice> option = fs.map(this::filterBaseFileAfterPendingCompaction).map(this::addBootstrapBaseFileIfPresent);
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partitionPath).filter(fg -> !this.isFileGroupReplaced(fg.getFileGroupId())).map(fileGroup -> {
                FileSlice fileSlice = fileGroup.getLatestFileSlice().get();
                Option<Pair<String, CompactionOperation>> compactionWithInstantPair = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
                if (compactionWithInstantPair.isPresent()) {
                    String compactionInstantTime = compactionWithInstantPair.get().getLeft();
                    return fileGroup.getLatestFileSliceBefore(compactionInstantTime);
                }
                return Option.of(fileSlice);
            }).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionStr, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> fileSliceStream = this.fetchLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime).filter(slice -> !this.isFileGroupReplacedBeforeOrOn(slice.getFileGroupId(), maxCommitTime));
            if (includeFileSlicesInPendingCompaction) {
                Stream<FileSlice> stream = fileSliceStream.map(this::filterBaseFileAfterPendingCompaction).map(this::addBootstrapBaseFileIfPresent);
                return stream;
            }
            Stream<FileSlice> stream = fileSliceStream.filter(fs -> !this.isPendingCompactionScheduledForFileId(fs.getFileGroupId())).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionStr, String maxInstantTime) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partition).filter(fg -> !this.isFileGroupReplacedBeforeOrOn(fg.getFileGroupId(), maxInstantTime)).map(fileGroup -> {
                Option<FileSlice> fileSlice = fileGroup.getLatestFileSliceBeforeOrOn(maxInstantTime);
                if (fileSlice.isPresent()) {
                    fileSlice = Option.of(this.fetchMergedFileSlice((HoodieFileGroup)fileGroup, fileSlice.get()));
                }
                return fileSlice;
            }).filter(Option::isPresent).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<FileSlice> stream = this.fetchLatestFileSliceInRange(commitsToReturn).filter(slice -> !this.isFileGroupReplacedBeforeAny(slice.getFileGroupId(), commitsToReturn)).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getAllFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllFileSlices(partition).filter(slice -> !this.isFileGroupReplaced(slice.getFileGroupId())).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String formatPartitionKey(String partitionStr) {
        return partitionStr.endsWith("/") ? partitionStr.substring(0, partitionStr.length() - 1) : partitionStr;
    }

    @Override
    public final Stream<HoodieFileGroup> getAllFileGroups(String partitionStr) {
        return this.getAllFileGroupsIncludingReplaced(partitionStr).filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<HoodieFileGroup> getAllFileGroupsIncludingReplaced(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<HoodieFileGroup> stream = this.fetchAllStoredFileGroups(partition).map(this::addBootstrapBaseFileIfPresent);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBeforeOrOn(String maxCommitTime, String partitionPath) {
        return this.getAllFileGroupsIncludingReplaced(partitionPath).filter(fg -> this.isFileGroupReplacedBeforeOrOn(fg.getFileGroupId(), maxCommitTime));
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBefore(String maxCommitTime, String partitionPath) {
        return this.getAllFileGroupsIncludingReplaced(partitionPath).filter(fg -> this.isFileGroupReplacedBefore(fg.getFileGroupId(), maxCommitTime));
    }

    @Override
    public Stream<HoodieFileGroup> getAllReplacedFileGroups(String partitionPath) {
        return this.getAllFileGroupsIncludingReplaced(partitionPath).filter(fg -> this.isFileGroupReplaced(fg.getFileGroupId()));
    }

    @Override
    public final Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClustering() {
        try {
            this.readLock.lock();
            Stream<Pair<HoodieFileGroupId, HoodieInstant>> stream = this.fetchFileGroupsInPendingClustering();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId var1);

    abstract void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    protected abstract boolean isPendingClusteringScheduledForFileId(HoodieFileGroupId var1);

    protected abstract Option<HoodieInstant> getPendingClusteringInstant(HoodieFileGroupId var1);

    protected abstract Stream<Pair<HoodieFileGroupId, HoodieInstant>> fetchFileGroupsInPendingClustering();

    abstract void resetFileGroupsInPendingClustering(Map<HoodieFileGroupId, HoodieInstant> var1);

    abstract void addFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> var1);

    abstract void removeFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> var1);

    protected abstract Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId var1);

    abstract Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations();

    protected abstract boolean isBootstrapBaseFilePresentForFileId(HoodieFileGroupId var1);

    abstract void resetBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    abstract void addBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    abstract void removeBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> var1);

    protected abstract Option<BootstrapBaseFileMapping> getBootstrapBaseFile(HoodieFileGroupId var1);

    abstract Stream<BootstrapBaseFileMapping> fetchBootstrapBaseFiles();

    abstract boolean isPartitionAvailableInStore(String var1);

    abstract void storePartitionView(String var1, List<HoodieFileGroup> var2);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups(String var1);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups();

    protected abstract void resetReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> var1);

    protected abstract void addReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> var1);

    protected abstract void removeReplacedFileIdsAtInstants(Set<String> var1);

    protected abstract Option<HoodieInstant> getReplaceInstant(HoodieFileGroupId var1);

    abstract boolean isClosed();

    Stream<FileSlice> fetchLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.fetchAllStoredFileGroups().map(fileGroup -> fileGroup.getLatestFileSliceInRange(commitsToReturn)).map(Option::get).map(this::addBootstrapBaseFileIfPresent);
    }

    Stream<FileSlice> fetchAllFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(this::addBootstrapBaseFileIfPresent).map(HoodieFileGroup::getAllFileSlices).flatMap(sliceList -> sliceList);
    }

    Stream<HoodieBaseFile> fetchLatestBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(fg -> Pair.of(fg.getFileGroupId(), this.getLatestBaseFile((HoodieFileGroup)fg))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
    }

    protected Option<HoodieBaseFile> getLatestBaseFile(HoodieFileGroup fileGroup) {
        return Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst());
    }

    private Stream<HoodieBaseFile> fetchLatestBaseFiles() {
        return this.fetchAllStoredFileGroups().filter(fg -> !this.isFileGroupReplaced((HoodieFileGroup)fg)).map(fg -> Pair.of(fg.getFileGroupId(), this.getLatestBaseFile((HoodieFileGroup)fg))).filter(p -> ((Option)p.getValue()).isPresent()).map(p -> this.addBootstrapBaseFileIfPresent((HoodieFileGroupId)p.getKey(), (HoodieBaseFile)((Option)p.getValue()).get()));
    }

    Stream<HoodieBaseFile> fetchAllBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getAllBaseFiles).flatMap(baseFileList -> baseFileList);
    }

    Option<HoodieFileGroup> fetchHoodieFileGroup(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchAllStoredFileGroups(partitionPath).filter(fileGroup -> fileGroup.getFileGroupId().getFileId().equals(fileId)).findFirst());
    }

    Stream<FileSlice> fetchLatestFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlice).filter(Option::isPresent).map(Option::get);
    }

    Stream<FileSlice> fetchLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime) {
        return this.fetchAllStoredFileGroups(partitionPath).map(fileGroup -> fileGroup.getLatestFileSliceBeforeOrOn(maxCommitTime)).filter(Option::isPresent).map(Option::get);
    }

    private static FileSlice mergeCompactionPendingFileSlices(FileSlice lastSlice, FileSlice penultimateSlice) {
        FileSlice merged = new FileSlice(penultimateSlice.getPartitionPath(), penultimateSlice.getBaseInstantTime(), penultimateSlice.getFileId());
        if (penultimateSlice.getBaseFile().isPresent()) {
            merged.setBaseFile(penultimateSlice.getBaseFile().get());
        }
        penultimateSlice.getLogFiles().forEach(merged::addLogFile);
        lastSlice.getLogFiles().forEach(merged::addLogFile);
        return merged;
    }

    private FileSlice fetchMergedFileSlice(HoodieFileGroup fileGroup, FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionOpWithInstant = this.getPendingCompactionOperationWithInstant(fileGroup.getFileGroupId());
        if (compactionOpWithInstant.isPresent()) {
            Option<FileSlice> prevFileSlice;
            String compactionInstantTime = compactionOpWithInstant.get().getKey();
            if (fileSlice.getBaseInstantTime().equals(compactionInstantTime) && (prevFileSlice = fileGroup.getLatestFileSliceBefore(compactionInstantTime)).isPresent()) {
                return AbstractTableFileSystemView.mergeCompactionPendingFileSlices(fileSlice, prevFileSlice.get());
            }
        }
        return fileSlice;
    }

    protected Option<HoodieBaseFile> fetchLatestBaseFile(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestBaseFiles(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    protected Option<FileSlice> fetchLatestFileSlice(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestFileSlices(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    private boolean isFileGroupReplaced(String partitionPath, String fileId) {
        return this.isFileGroupReplaced(new HoodieFileGroupId(partitionPath, fileId));
    }

    private boolean isFileGroupReplaced(HoodieFileGroup fileGroup) {
        return this.isFileGroupReplaced(fileGroup.getFileGroupId());
    }

    private boolean isFileGroupReplaced(HoodieFileGroupId fileGroup) {
        return this.getReplaceInstant(fileGroup).isPresent();
    }

    private boolean isFileGroupReplacedBeforeAny(HoodieFileGroupId fileGroupId, List<String> instants) {
        return this.isFileGroupReplacedBeforeOrOn(fileGroupId, (String)instants.stream().max(Comparator.naturalOrder()).get());
    }

    private boolean isFileGroupReplacedBefore(HoodieFileGroupId fileGroupId, String instant) {
        Option<HoodieInstant> hoodieInstantOption = this.getReplaceInstant(fileGroupId);
        if (!hoodieInstantOption.isPresent()) {
            return false;
        }
        return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN, hoodieInstantOption.get().getTimestamp());
    }

    private boolean isFileGroupReplacedBeforeOrOn(HoodieFileGroupId fileGroupId, String instant) {
        Option<HoodieInstant> hoodieInstantOption = this.getReplaceInstant(fileGroupId);
        if (!hoodieInstantOption.isPresent()) {
            return false;
        }
        return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN_OR_EQUALS, hoodieInstantOption.get().getTimestamp());
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.getTimeline().lastInstant();
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    @Override
    public void sync() {
        HoodieTimeline oldTimeline = this.getTimeline();
        HoodieTimeline newTimeline = this.metaClient.reloadActiveTimeline().filterCompletedAndCompactionInstants();
        try {
            this.writeLock.lock();
            this.runSync(oldTimeline, newTimeline);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void runSync(HoodieTimeline oldTimeline, HoodieTimeline newTimeline) {
        this.refreshTimeline(newTimeline);
        this.addedPartitions.clear();
        this.resetViewState();
        this.init(this.metaClient, newTimeline);
    }

    public HoodieTimeline getVisibleCommitsAndCompactionTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$ensurePartitionLoadedCorrectly$9(String partitionPathStr) {
        beginTs = System.currentTimeMillis();
        if (!this.isPartitionAvailableInStore(partitionPathStr)) {
            try {
                AbstractTableFileSystemView.LOG.info((Object)("Building file system view for partition (" + partitionPathStr + ")"));
                partitionPath = FSUtils.getPartitionPath(this.metaClient.getBasePath(), partitionPathStr);
                FSUtils.createPathIfNotExists(this.metaClient.getFs(), partitionPath);
                beginLsTs = System.currentTimeMillis();
                statuses = this.listPartition(partitionPath);
                endLsTs = System.currentTimeMillis();
                AbstractTableFileSystemView.LOG.debug((Object)("#files found in partition (" + partitionPathStr + ") =" + statuses.length + ", Time taken =" + (endLsTs - beginLsTs)));
                groups = this.addFilesToView(statuses);
                if (!groups.isEmpty()) ** GOTO lbl18
                this.storePartitionView(partitionPathStr, new ArrayList<HoodieFileGroup>());
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to list base files in partition " + partitionPathStr, e);
            }
        } else {
            AbstractTableFileSystemView.LOG.debug((Object)("View already built for Partition :" + partitionPathStr + ", FOUND is "));
        }
lbl18:
        // 3 sources

        endTs = System.currentTimeMillis();
        AbstractTableFileSystemView.LOG.debug((Object)("Time to load partition (" + partitionPathStr + ") =" + (endTs - beginTs)));
        return true;
    }
}

