/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerUtils {
    public static final String MARKERS_FILENAME_PREFIX = "MARKERS";
    public static final String MARKER_TYPE_FILENAME = "MARKERS.type";
    private static final Logger LOG = LogManager.getLogger(MarkerUtils.class);

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String basePath, String instantTime) {
        ValidationUtils.checkArgument(fullMarkerPath.contains(".marker"));
        String markerRootPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(String.format("%s/%s/%s", basePath, HoodieTableMetaClient.TEMPFOLDER_NAME, instantTime))).toString();
        return MarkerUtils.stripMarkerFolderPrefix(fullMarkerPath, markerRootPath);
    }

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String markerDir) {
        int begin = fullMarkerPath.indexOf(markerDir);
        ValidationUtils.checkArgument(begin >= 0, "Not in marker dir. Marker Path=" + fullMarkerPath + ", Expected Marker Root=" + markerDir);
        return fullMarkerPath.substring(begin + markerDir.length() + 1);
    }

    public static boolean doesMarkerTypeFileExist(FileSystem fileSystem, String markerDir) throws IOException {
        return fileSystem.exists(new Path(markerDir, MARKER_TYPE_FILENAME));
    }

    public static Option<MarkerType> readMarkerType(FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataInputStream fsDataInputStream = null;
        Option<MarkerType> content = Option.empty();
        try {
            if (!MarkerUtils.doesMarkerTypeFileExist(fileSystem, markerDir)) {
                Option<MarkerType> option = Option.empty();
                return option;
            }
            fsDataInputStream = fileSystem.open(markerTypeFilePath);
            content = Option.of(MarkerType.valueOf(FileIOUtils.readAsUTFString((InputStream)fsDataInputStream)));
            FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
        finally {
            FileIOUtils.closeQuietly(fsDataInputStream);
        }
        return content;
    }

    public static void writeMarkerTypeToFile(MarkerType markerType, FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataOutputStream fsDataOutputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            fsDataOutputStream = fileSystem.create(markerTypeFilePath, false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fsDataOutputStream, StandardCharsets.UTF_8));
            bufferedWriter.write(markerType.toString());
        }
        catch (IOException e) {
            try {
                throw new HoodieException("Failed to create marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(bufferedWriter);
                FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly(bufferedWriter);
        FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
    }

    public static void deleteMarkerTypeFile(FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        try {
            fileSystem.delete(markerTypeFilePath, false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot delete marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
    }

    public static Map<String, Set<String>> readTimelineServerBasedMarkersFromFileSystem(String markerDir, FileSystem fileSystem, HoodieEngineContext context, int parallelism) {
        Path dirPath = new Path(markerDir);
        try {
            if (fileSystem.exists(dirPath)) {
                FileStatus[] fileStatuses = fileSystem.listStatus(dirPath);
                Predicate<FileStatus> prefixFilter = fileStatus -> fileStatus.getPath().getName().startsWith(MARKERS_FILENAME_PREFIX);
                Predicate<FileStatus> markerTypeFilter = fileStatus -> !fileStatus.getPath().getName().equals(MARKER_TYPE_FILENAME);
                List markerDirSubPaths = Arrays.stream(fileStatuses).filter(prefixFilter.and(markerTypeFilter)).map(fileStatus -> fileStatus.getPath().toString()).collect(Collectors.toList());
                if (markerDirSubPaths.size() > 0) {
                    SerializableConfiguration conf = new SerializableConfiguration(fileSystem.getConf());
                    int actualParallelism = Math.min(markerDirSubPaths.size(), parallelism);
                    return context.mapToPair(markerDirSubPaths, markersFilePathStr -> {
                        Path markersFilePath = new Path(markersFilePathStr);
                        FileSystem fs = markersFilePath.getFileSystem(conf.get());
                        FSDataInputStream fsDataInputStream = null;
                        BufferedReader bufferedReader = null;
                        Set<Object> markers = new HashSet();
                        try {
                            LOG.debug((Object)("Read marker file: " + markersFilePathStr));
                            fsDataInputStream = fs.open(markersFilePath);
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream, StandardCharsets.UTF_8));
                            markers = bufferedReader.lines().collect(Collectors.toSet());
                        }
                        catch (IOException e) {
                            try {
                                throw new HoodieIOException("Failed to read file " + markersFilePathStr, e);
                            }
                            catch (Throwable throwable) {
                                FileIOUtils.closeQuietly(bufferedReader);
                                FileIOUtils.closeQuietly(fsDataInputStream);
                                throw throwable;
                            }
                        }
                        FileIOUtils.closeQuietly(bufferedReader);
                        FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
                        return new ImmutablePair((String)markersFilePathStr, markers);
                    }, actualParallelism);
                }
            }
            return new HashMap<String, Set<String>>();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }
}

