/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public class ParquetUtils
extends BaseFileUtils {
    @Override
    public Set<String> filterRowKeys(Configuration configuration, Path filePath, Set<String> filter) {
        return ParquetUtils.filterParquetRowKeys(configuration, filePath, filter, HoodieAvroUtils.getRecordKeySchema());
    }

    private static Set<String> filterParquetRowKeys(Configuration configuration, Path filePath, Set<String> filter, Schema readSchema) {
        Option<Object> filterFunction = Option.empty();
        if (filter != null && !filter.isEmpty()) {
            filterFunction = Option.of(new RecordKeysFilterFunction(filter));
        }
        Configuration conf = new Configuration(configuration);
        conf.addResource(FSUtils.getFs(filePath.toString(), conf).getConf());
        AvroReadSupport.setAvroReadSchema(conf, readSchema);
        AvroReadSupport.setRequestedProjection(conf, readSchema);
        HashSet<String> rowKeys = new HashSet<String>();
        try (ParquetReader reader = AvroParquetReader.builder(filePath).withConf(conf).build();){
            Object obj = reader.read();
            while (obj != null) {
                if (obj instanceof GenericRecord) {
                    String recordKey = ((GenericRecord)obj).get("_hoodie_record_key").toString();
                    if (!filterFunction.isPresent() || ((RecordKeysFilterFunction)filterFunction.get()).apply(recordKey).booleanValue()) {
                        rowKeys.add(recordKey);
                    }
                }
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read row keys from Parquet " + filePath, e);
        }
        return rowKeys;
    }

    @Override
    public List<HoodieKey> fetchRecordKeyPartitionPath(Configuration configuration, Path filePath) {
        return this.fetchRecordKeyPartitionPathInternal(configuration, filePath, Option.empty());
    }

    private List<HoodieKey> fetchRecordKeyPartitionPathInternal(Configuration configuration, Path filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        ArrayList<HoodieKey> hoodieKeys = new ArrayList<HoodieKey>();
        try {
            Configuration conf = new Configuration(configuration);
            conf.addResource(FSUtils.getFs(filePath.toString(), conf).getConf());
            Schema readSchema = keyGeneratorOpt.map(keyGenerator -> {
                ArrayList<String> fields = new ArrayList<String>();
                fields.addAll(keyGenerator.getRecordKeyFields());
                fields.addAll(keyGenerator.getPartitionPathFields());
                return HoodieAvroUtils.getSchemaForFields(this.readAvroSchema(conf, filePath), fields);
            }).orElse(HoodieAvroUtils.getRecordKeyPartitionPathSchema());
            AvroReadSupport.setAvroReadSchema(conf, readSchema);
            AvroReadSupport.setRequestedProjection(conf, readSchema);
            ParquetReader reader = AvroParquetReader.builder(filePath).withConf(conf).build();
            Object obj = reader.read();
            while (obj != null) {
                if (!(obj instanceof GenericRecord)) continue;
                String recordKey = null;
                String partitionPath = null;
                if (keyGeneratorOpt.isPresent()) {
                    recordKey = keyGeneratorOpt.get().getRecordKey((GenericRecord)obj);
                    partitionPath = keyGeneratorOpt.get().getPartitionPath((GenericRecord)obj);
                } else {
                    recordKey = ((GenericRecord)obj).get("_hoodie_record_key").toString();
                    partitionPath = ((GenericRecord)obj).get("_hoodie_partition_path").toString();
                }
                hoodieKeys.add(new HoodieKey(recordKey, partitionPath));
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read from Parquet file " + filePath, e);
        }
        return hoodieKeys;
    }

    @Override
    public List<HoodieKey> fetchRecordKeyPartitionPath(Configuration configuration, Path filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return this.fetchRecordKeyPartitionPathInternal(configuration, filePath, keyGeneratorOpt);
    }

    public ParquetMetadata readMetadata(Configuration conf, Path parquetFilePath) {
        ParquetMetadata footer;
        try {
            footer = ParquetFileReader.readFooter((Configuration)FSUtils.getFs(parquetFilePath.toString(), conf).getConf(), (Path)parquetFilePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read footer for parquet " + parquetFilePath, e);
        }
        return footer;
    }

    public MessageType readSchema(Configuration configuration, Path parquetFilePath) {
        return this.readMetadata(configuration, parquetFilePath).getFileMetaData().getSchema();
    }

    @Override
    public Map<String, String> readFooter(Configuration configuration, boolean required, Path parquetFilePath, String ... footerNames) {
        HashMap<String, String> footerVals = new HashMap<String, String>();
        ParquetMetadata footer = this.readMetadata(configuration, parquetFilePath);
        Map metadata = footer.getFileMetaData().getKeyValueMetaData();
        for (String footerName : footerNames) {
            if (metadata.containsKey(footerName)) {
                footerVals.put(footerName, (String)metadata.get(footerName));
                continue;
            }
            if (!required) continue;
            throw new MetadataNotFoundException("Could not find index in Parquet footer. Looked for key " + footerName + " in " + parquetFilePath);
        }
        return footerVals;
    }

    @Override
    public Schema readAvroSchema(Configuration configuration, Path parquetFilePath) {
        MessageType parquetSchema = this.readSchema(configuration, parquetFilePath);
        return new AvroSchemaConverter(configuration).convert(parquetSchema);
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath) {
        ParquetReader reader = null;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try {
            reader = AvroParquetReader.builder(filePath).withConf(configuration).build();
            Object obj = reader.read();
            while (obj != null) {
                if (obj instanceof GenericRecord) {
                    records.add((GenericRecord)obj);
                }
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read avro records from Parquet " + filePath, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return records;
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath, Schema schema) {
        AvroReadSupport.setAvroReadSchema(configuration, schema);
        return this.readAvroRecords(configuration, filePath);
    }

    @Override
    public long getRowCount(Configuration conf, Path parquetFilePath) {
        long rowCount = 0L;
        ParquetMetadata footer = this.readMetadata(conf, parquetFilePath);
        for (BlockMetaData b : footer.getBlocks()) {
            rowCount += b.getRowCount();
        }
        return rowCount;
    }

    static class RecordKeysFilterFunction
    implements Function<String, Boolean> {
        private final Set<String> candidateKeys;

        RecordKeysFilterFunction(Set<String> candidateKeys) {
            this.candidateKeys = candidateKeys;
        }

        @Override
        public Boolean apply(String recordKey) {
            return this.candidateKeys.contains(recordKey);
        }
    }
}

