/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueue;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueProducer;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BoundedInMemoryExecutor<I, O, E> {
    private static final Logger LOG = LogManager.getLogger(BoundedInMemoryExecutor.class);
    private final ExecutorService executorService;
    private final BoundedInMemoryQueue<I, O> queue;
    private final List<BoundedInMemoryQueueProducer<I>> producers;
    private final Option<BoundedInMemoryQueueConsumer<O, E>> consumer;

    public BoundedInMemoryExecutor(long bufferLimitInBytes, BoundedInMemoryQueueProducer<I> producer, Option<BoundedInMemoryQueueConsumer<O, E>> consumer, Function<I, O> transformFunction) {
        this(bufferLimitInBytes, Arrays.asList(producer), consumer, transformFunction, new DefaultSizeEstimator());
    }

    public BoundedInMemoryExecutor(long bufferLimitInBytes, List<BoundedInMemoryQueueProducer<I>> producers, Option<BoundedInMemoryQueueConsumer<O, E>> consumer, Function<I, O> transformFunction, SizeEstimator<O> sizeEstimator) {
        this.producers = producers;
        this.consumer = consumer;
        this.executorService = Executors.newFixedThreadPool(producers.size() + 1);
        this.queue = new BoundedInMemoryQueue<I, O>(bufferLimitInBytes, transformFunction, sizeEstimator);
    }

    public void preExecute() {
    }

    public ExecutorCompletionService<Boolean> startProducers() {
        CountDownLatch latch = new CountDownLatch(this.producers.size());
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(this.executorService);
        this.producers.stream().map(producer -> completionService.submit(() -> {
            try {
                this.preExecute();
                producer.produce(this.queue);
            }
            catch (Exception e) {
                LOG.error((Object)"error producing records", (Throwable)e);
                this.queue.markAsFailed(e);
                throw e;
            }
            finally {
                CountDownLatch countDownLatch = latch;
                synchronized (countDownLatch) {
                    latch.countDown();
                    if (latch.getCount() == 0L) {
                        this.queue.close();
                    }
                }
            }
            return true;
        })).collect(Collectors.toList());
        return completionService;
    }

    private Future<E> startConsumer() {
        return this.consumer.map(consumer -> this.executorService.submit(() -> {
            LOG.info((Object)"starting consumer thread");
            this.preExecute();
            try {
                Object result = consumer.consume(this.queue);
                LOG.info((Object)"Queue Consumption is done; notifying producer threads");
                return result;
            }
            catch (Exception e) {
                LOG.error((Object)"error consuming records", (Throwable)e);
                this.queue.markAsFailed(e);
                throw e;
            }
        })).orElse(CompletableFuture.completedFuture(null));
    }

    public E execute() {
        try {
            ExecutorCompletionService<Boolean> producerService = this.startProducers();
            Future<E> future = this.startConsumer();
            return future.get();
        }
        catch (InterruptedException ie) {
            this.shutdownNow();
            Thread.currentThread().interrupt();
            throw new HoodieException(ie);
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
    }

    public boolean isRemaining() {
        return this.queue.iterator().hasNext();
    }

    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    public BoundedInMemoryQueue<I, O> getQueue() {
        return this.queue;
    }
}

