/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.constant;

import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Key Generator Options", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Hudi maintains keys (record key + partition path) for uniquely identifying a particular record. This config allows developers to setup the Key generator class that will extract these out of incoming records.")
public class KeyGeneratorOptions
extends HoodieConfig {
    public static final ConfigProperty<String> URL_ENCODE_PARTITIONING = ConfigProperty.key("hoodie.datasource.write.partitionpath.urlencode").defaultValue("false").withDocumentation("Should we url encode the partition path value, before creating the folder structure.");
    public static final ConfigProperty<String> HIVE_STYLE_PARTITIONING_ENABLE = ConfigProperty.key("hoodie.datasource.write.hive_style_partitioning").defaultValue("false").withDocumentation("Flag to indicate whether to use Hive style partitioning.\nIf set true, the names of partition folders follow <partition_column_name>=<partition_value> format.\nBy default false (the names of partition folders are only partition values)");
    public static final ConfigProperty<String> RECORDKEY_FIELD_NAME = ConfigProperty.key("hoodie.datasource.write.recordkey.field").defaultValue("uuid").withDocumentation("Record key field. Value to be used as the `recordKey` component of `HoodieKey`.\nActual value will be obtained by invoking .toString() on the field value. Nested fields can be specified using\nthe dot notation eg: `a.b.c`");
    public static final ConfigProperty<String> PARTITIONPATH_FIELD_NAME = ConfigProperty.key("hoodie.datasource.write.partitionpath.field").defaultValue("partitionpath").withDocumentation("Partition path field. Value to be used at the partitionPath component of HoodieKey. Actual value ontained by invoking .toString()");
    @Deprecated
    public static final String URL_ENCODE_PARTITIONING_OPT_KEY = URL_ENCODE_PARTITIONING.key();
    @Deprecated
    public static final String DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL = URL_ENCODE_PARTITIONING.defaultValue();
    @Deprecated
    public static final String HIVE_STYLE_PARTITIONING_OPT_KEY = HIVE_STYLE_PARTITIONING_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL = HIVE_STYLE_PARTITIONING_ENABLE.defaultValue();
    @Deprecated
    public static final String RECORDKEY_FIELD_OPT_KEY = RECORDKEY_FIELD_NAME.key();
    @Deprecated
    public static final String PARTITIONPATH_FIELD_OPT_KEY = PARTITIONPATH_FIELD_NAME.key();
}

