/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.metadata.BaseTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMergedLogRecordScanner;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBackedTableMetadata
extends BaseTableMetadata {
    private static final Logger LOG = LogManager.getLogger(HoodieBackedTableMetadata.class);
    private String metadataBasePath;
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private List<FileSlice> latestFileSystemMetadataSlices;
    private final boolean reuse;
    private transient HoodieFileReader<GenericRecord> baseFileReader;
    private transient HoodieMetadataMergedLogRecordScanner logRecordScanner;

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory) {
        this(engineContext, metadataConfig, datasetBasePath, spillableMapDirectory, false);
    }

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory, boolean reuse) {
        super(engineContext, metadataConfig, datasetBasePath, spillableMapDirectory);
        this.reuse = reuse;
        this.initIfNeeded();
    }

    private void initIfNeeded() {
        if (!this.enabled) {
            LOG.info((Object)("Metadata table is disabled for " + this.datasetBasePath));
        } else if (this.metaClient == null) {
            this.metadataBasePath = HoodieTableMetadata.getMetadataTableBasePath(this.datasetBasePath);
            try {
                this.metaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(this.metadataBasePath).build();
                this.tableConfig = this.metaClient.getTableConfig();
                HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getActiveTimeline());
                this.latestFileSystemMetadataSlices = fsView.getLatestFileSlices(MetadataPartitionType.FILES.partitionPath()).collect(Collectors.toList());
            }
            catch (TableNotFoundException e) {
                LOG.warn((Object)("Metadata table was not found at path " + this.metadataBasePath));
                this.enabled = false;
                this.metaClient = null;
                this.tableConfig = null;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to initialize metadata table at path " + this.metadataBasePath), (Throwable)e);
                this.enabled = false;
                this.metaClient = null;
                this.tableConfig = null;
            }
            if (this.enabled) {
                this.openTimelineScanner(this.metaClient.getActiveTimeline());
            }
        }
    }

    @Override
    protected Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKeyFromMetadata(String key) {
        this.openReadersIfNeededOrThrow();
        try {
            Option<HoodieRecord<HoodieMetadataPayload>> logHoodieRecord;
            ArrayList<Long> timings = new ArrayList<Long>();
            HoodieTimer timer = new HoodieTimer().startTimer();
            HoodieRecord<HoodieMetadataPayload> hoodieRecord = null;
            if (this.baseFileReader != null) {
                HoodieTimer readTimer = new HoodieTimer().startTimer();
                Option<GenericRecord> baseRecord = this.baseFileReader.getRecordByKey(key);
                if (baseRecord.isPresent()) {
                    hoodieRecord = this.tableConfig.populateMetaFields() ? (HoodieRecord<HoodieMetadataPayload>)SpillableMapUtils.convertToHoodieRecordPayload(baseRecord.get(), this.tableConfig.getPayloadClass(), this.tableConfig.getPreCombineField(), false) : (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(baseRecord.get(), this.tableConfig.getPayloadClass(), this.tableConfig.getPreCombineField(), Pair.of(this.tableConfig.getRecordKeyFieldProp(), this.tableConfig.getPartitionFieldProp()), false);
                    this.metrics.ifPresent(m -> m.updateMetrics("basefile_read", readTimer.endTimer()));
                }
            }
            timings.add(timer.endTimer());
            timer.startTimer();
            if (this.logRecordScanner != null && (logHoodieRecord = this.logRecordScanner.getRecordByKey(key)).isPresent()) {
                if (hoodieRecord != null) {
                    HoodieMetadataPayload mergedPayload = logHoodieRecord.get().getData().preCombine(hoodieRecord.getData());
                    hoodieRecord = new HoodieRecord<HoodieMetadataPayload>(hoodieRecord.getKey(), mergedPayload);
                } else {
                    hoodieRecord = logHoodieRecord.get();
                }
            }
            timings.add(timer.endTimer());
            LOG.info((Object)String.format("Metadata read for key %s took [baseFileRead, logMerge] %s ms", key, timings));
            Option<HoodieRecord<HoodieMetadataPayload>> option = Option.ofNullable(hoodieRecord);
            return option;
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error merging records from metadata table for key :" + key, ioe);
        }
        finally {
            if (!this.reuse) {
                this.closeOrThrow();
            }
        }
    }

    private void openReadersIfNeededOrThrow() {
        try {
            this.openReadersIfNeeded();
        }
        catch (IOException e) {
            throw new HoodieIOException("Error opening readers to the Metadata Table: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReadersIfNeeded() throws IOException {
        if (this.reuse && (this.baseFileReader != null || this.logRecordScanner != null)) {
            return;
        }
        HoodieBackedTableMetadata hoodieBackedTableMetadata = this;
        synchronized (hoodieBackedTableMetadata) {
            long baseFileOpenMs;
            if (this.baseFileReader != null || this.logRecordScanner != null) {
                return;
            }
            HoodieTimer timer = new HoodieTimer().startTimer();
            String latestInstantTime = this.getLatestDatasetInstantTime();
            ValidationUtils.checkArgument(this.latestFileSystemMetadataSlices.size() == 1, "must be at-least one valid metadata file slice");
            Option<HoodieBaseFile> basefile = this.latestFileSystemMetadataSlices.get(0).getBaseFile();
            if (basefile.isPresent()) {
                String basefilePath = basefile.get().getPath();
                this.baseFileReader = HoodieFileReaderFactory.getFileReader(this.hadoopConf.get(), new Path(basefilePath));
                baseFileOpenMs = timer.endTimer();
                LOG.info((Object)String.format("Opened metadata base file from %s at instant %s in %d ms", basefilePath, basefile.get().getCommitTime(), baseFileOpenMs));
            } else {
                baseFileOpenMs = 0L;
                timer.endTimer();
            }
            timer.startTimer();
            List logFilePaths = this.latestFileSystemMetadataSlices.get(0).getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(o -> o.getPath().toString()).collect(Collectors.toList());
            Option<HoodieInstant> lastInstant = this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
            String latestMetaInstantTimestamp = lastInstant.map(HoodieInstant::getTimestamp).orElse("0000000000000");
            Schema schema = HoodieAvroUtils.addMetadataFields(HoodieMetadataRecord.getClassSchema());
            HoodieCommonConfig commonConfig = HoodieCommonConfig.newBuilder().fromProperties(this.metadataConfig.getProps()).build();
            this.logRecordScanner = ((HoodieMetadataMergedLogRecordScanner.Builder)HoodieMetadataMergedLogRecordScanner.newBuilder().withFileSystem(this.metaClient.getFs()).withBasePath(this.metadataBasePath).withLogFilePaths(logFilePaths)).withReaderSchema(schema).withLatestInstantTime(latestMetaInstantTimestamp).withMaxMemorySizeInBytes(0x40000000L).withBufferSize(0xA00000).withSpillableMapBasePath(this.spillableMapDirectory).withDiskMapType(commonConfig.getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(commonConfig.isBitCaskDiskMapCompressionEnabled()).build();
            long logScannerOpenMs = timer.endTimer();
            LOG.info((Object)String.format("Opened metadata log files from %s at instant (dataset instant=%s, metadata instant=%s) in %d ms", logFilePaths, latestInstantTime, latestMetaInstantTimestamp, logScannerOpenMs));
            this.metrics.ifPresent(metrics -> metrics.updateMetrics("scan", baseFileOpenMs + logScannerOpenMs));
        }
    }

    private void close(HoodieFileReader localFileReader, HoodieMetadataMergedLogRecordScanner localLogScanner) {
        try {
            if (localFileReader != null) {
                localFileReader.close();
            }
            if (localLogScanner != null) {
                localLogScanner.close();
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error closing resources during metadata table merge", e);
        }
    }

    private void closeOrThrow() {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new HoodieException("Error closing metadata table readers", e);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.close(this.baseFileReader, this.logRecordScanner);
        this.baseFileReader = null;
        this.logRecordScanner = null;
    }

    @Override
    public Option<String> getUpdateTime() {
        if (!this.enabled) {
            return Option.empty();
        }
        HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
        return timeline.getDeltaCommitTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp);
    }

    @Override
    protected List<HoodieInstant> findInstantsToSyncForReader() {
        return this.findInstantsToSync(true);
    }

    @Override
    protected List<HoodieInstant> findInstantsToSyncForWriter() {
        return this.findInstantsToSync(false);
    }

    private List<HoodieInstant> findInstantsToSync(boolean ignoreIncompleteInstants) {
        Option earliestIncompleteInstant;
        this.initIfNeeded();
        if (!this.enabled || !this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().isPresent()) {
            return Collections.EMPTY_LIST;
        }
        String latestMetadataInstantTime = this.metaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant().get().getTimestamp();
        HoodieDefaultTimeline candidateTimeline = this.datasetMetaClient.getActiveTimeline().findInstantsAfter(latestMetadataInstantTime, Integer.MAX_VALUE);
        Option<Object> option = earliestIncompleteInstant = ignoreIncompleteInstants ? Option.empty() : candidateTimeline.filterInflightsAndRequested().firstInstant();
        if (earliestIncompleteInstant.isPresent()) {
            return candidateTimeline.filterCompletedInstants().findInstantsBefore(((HoodieInstant)earliestIncompleteInstant.get()).getTimestamp()).getInstants().collect(Collectors.toList());
        }
        return candidateTimeline.filterCompletedInstants().getInstants().collect(Collectors.toList());
    }

    public boolean enabled() {
        return this.enabled;
    }

    public SerializableConfiguration getHadoopConf() {
        return this.hadoopConf;
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    public Map<String, String> stats() {
        return this.metrics.map(m -> m.getStats(true, this.metaClient, (HoodieTableMetadata)this)).orElse(new HashMap());
    }
}

