/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieMetadataMergedLogRecordScanner
extends HoodieMergedLogRecordScanner {
    private Set<String> mergeKeyFilter;

    private HoodieMetadataMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, int bufferSize, String spillableMapBasePath, Set<String> mergeKeyFilter, ExternalSpillableMap.DiskMapType diskMapType, boolean isBitCaskDiskMapCompressionEnabled) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, maxMemorySizeInBytes, false, false, bufferSize, spillableMapBasePath, Option.empty(), false, diskMapType, isBitCaskDiskMapCompressionEnabled, false);
        this.mergeKeyFilter = mergeKeyFilter;
        this.performScan();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieRecord.getRecordKey())) {
            super.processNextRecord(hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(hoodieKey.getRecordKey())) {
            super.processNextDeletedKey(hoodieKey);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String key) {
        return Option.ofNullable((HoodieRecord)this.records.get(key));
    }

    public static class Builder
    extends HoodieMergedLogRecordScanner.Builder {
        private Set<String> mergeKeyFilter = Collections.emptySet();

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
            return this;
        }

        @Override
        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.spillableMapBasePath = spillableMapBasePath;
            return this;
        }

        @Override
        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.diskMapType = diskMapType;
            return this;
        }

        @Override
        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.isBitCaskDiskMapCompressionEnabled = isBitCaskDiskMapCompressionEnabled;
            return this;
        }

        public Builder withMergeKeyFilter(Set<String> mergeKeyFilter) {
            this.mergeKeyFilter = mergeKeyFilter;
            return this;
        }

        @Override
        public HoodieMetadataMergedLogRecordScanner build() {
            return new HoodieMetadataMergedLogRecordScanner(this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.maxMemorySizeInBytes, this.bufferSize, this.spillableMapBasePath, this.mergeKeyFilter, this.diskMapType, this.isBitCaskDiskMapCompressionEnabled);
        }
    }
}

