/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hudi.avro.AvroSchemaCompatibility;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.SchemaCompatibility;

public class AvroSchemaUtils {
    private AvroSchemaUtils() {
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema) {
        return AvroSchemaUtils.isSchemaCompatible(prevSchema, newSchema, true);
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean allowProjection) {
        return AvroSchemaUtils.isSchemaCompatible(prevSchema, newSchema, true, allowProjection);
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean checkNaming, boolean allowProjection) {
        if (!allowProjection && !AvroSchemaUtils.canProject(prevSchema, newSchema)) {
            return false;
        }
        AvroSchemaCompatibility.SchemaPairCompatibility result = AvroSchemaCompatibility.checkReaderWriterCompatibility(newSchema, prevSchema, checkNaming);
        return result.getType() == AvroSchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public static boolean canProject(Schema prevSchema, Schema newSchema) {
        return AvroSchemaUtils.canProject(prevSchema, newSchema, Collections.emptySet());
    }

    public static boolean canProject(Schema prevSchema, Schema newSchema, Set<String> exceptCols) {
        return prevSchema.getFields().stream().filter(f -> !exceptCols.contains(f.name())).map(oldSchemaField -> SchemaCompatibility.lookupWriterField(newSchema, oldSchemaField)).noneMatch(Objects::isNull);
    }

    public static String getAvroRecordQualifiedName(String tableName) {
        String sanitizedTableName = HoodieAvroUtils.sanitizeName(tableName);
        return "hoodie." + sanitizedTableName + "." + sanitizedTableName + "_record";
    }

    public static boolean isValidEvolutionOf(Schema sourceSchema, Schema targetSchema) {
        return sourceSchema.getType() == Schema.Type.NULL || AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, AvroSchemaUtils::isAtomicSchemasCompatibleEvolution);
    }

    private static boolean isAtomicSchemasCompatibleEvolution(Schema newReaderSchema, Schema prevWriterSchema) {
        return AvroSchemaUtils.isSchemaCompatible(prevWriterSchema, newReaderSchema, false, true);
    }

    public static boolean isCompatibleProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, AvroSchemaUtils::isAtomicSchemasCompatible);
    }

    private static boolean isAtomicSchemasCompatible(Schema oneAtomicType, Schema anotherAtomicType) {
        return AvroSchemaUtils.isSchemaCompatible(oneAtomicType, anotherAtomicType, false, true);
    }

    public static boolean isStrictProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, Objects::equals);
    }

    private static boolean isProjectionOfInternal(Schema sourceSchema, Schema targetSchema, BiFunction<Schema, Schema, Boolean> atomicTypeEqualityPredicate) {
        if (sourceSchema.getType() == targetSchema.getType()) {
            if (sourceSchema.getType() == Schema.Type.RECORD) {
                for (Schema.Field targetField : targetSchema.getFields()) {
                    Schema.Field sourceField = sourceSchema.getField(targetField.name());
                    if (sourceField != null && AvroSchemaUtils.isProjectionOfInternal(sourceField.schema(), targetField.schema(), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
            if (sourceSchema.getType() == Schema.Type.ARRAY) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getElementType(), targetSchema.getElementType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.MAP) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getValueType(), targetSchema.getValueType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.UNION) {
                List<Schema> sourceNestedSchemas = sourceSchema.getTypes();
                List<Schema> targetNestedSchemas = targetSchema.getTypes();
                if (sourceNestedSchemas.size() != targetNestedSchemas.size()) {
                    return false;
                }
                for (int i = 0; i < sourceNestedSchemas.size(); ++i) {
                    if (AvroSchemaUtils.isProjectionOfInternal(sourceNestedSchemas.get(i), targetNestedSchemas.get(i), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
        }
        return atomicTypeEqualityPredicate.apply(sourceSchema, targetSchema);
    }

    public static Schema appendFieldsToSchema(Schema schema, List<Schema.Field> newFields) {
        List<Schema.Field> fields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        fields.addAll(newFields);
        Schema newSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), schema.isError());
        newSchema.setFields(fields);
        return newSchema;
    }

    public static Schema resolveUnionSchema(Schema schema, String fieldSchemaFullName) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List<Schema> innerTypes = schema.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL && Objects.equals(it.getFullName(), fieldSchemaFullName)).findFirst().orElse(null);
        if (nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return nonNullType;
    }

    public static boolean isNullable(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        List<Schema> innerTypes = schema.getTypes();
        return innerTypes.size() > 1 && innerTypes.stream().anyMatch(it -> it.getType() == Schema.Type.NULL);
    }

    public static Schema resolveNullableSchema(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List<Schema> innerTypes = schema.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL).findFirst().orElse(null);
        if (innerTypes.size() != 2 || nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return nonNullType;
    }

    public static Schema createNullableSchema(Schema.Type avroType) {
        return AvroSchemaUtils.createNullableSchema(Schema.create(avroType));
    }

    public static Schema createNullableSchema(Schema schema) {
        ValidationUtils.checkState(schema.getType() != Schema.Type.NULL);
        return Schema.createUnion(Schema.create(Schema.Type.NULL), schema);
    }

    public static boolean containsFieldInSchema(Schema schema, String fieldName) {
        try {
            Schema.Field field = schema.getField(fieldName);
            return field != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkSchemaCompatible(Schema tableSchema, Schema writerSchema, boolean shouldValidate, boolean allowProjection, Set<String> dropPartitionColNames) throws SchemaCompatibilityException {
        String errorMessage = null;
        if (!allowProjection && !AvroSchemaUtils.canProject(tableSchema, writerSchema, dropPartitionColNames)) {
            errorMessage = "Column dropping is not allowed";
        }
        if (dropPartitionColNames.isEmpty() && shouldValidate && !AvroSchemaUtils.isSchemaCompatible(tableSchema, writerSchema)) {
            errorMessage = "Failed schema compatibility check";
        }
        if (errorMessage != null) {
            String errorDetails = String.format("%s\nwriterSchema: %s\ntableSchema: %s", errorMessage, writerSchema, tableSchema);
            throw new SchemaCompatibilityException(errorDetails);
        }
    }
}

