/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.BloomFilterUtils;
import org.apache.hudi.common.bloom.InternalDynamicBloomFilter;
import org.apache.hudi.common.bloom.Key;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIndexException;

public class HoodieDynamicBoundedBloomFilter
implements BloomFilter {
    public static final String TYPE_CODE_PREFIX = "DYNAMIC";
    private InternalDynamicBloomFilter internalDynamicBloomFilter;

    HoodieDynamicBoundedBloomFilter(int numEntries, double errorRate, int hashType, int maxNoOfEntries) {
        int bitSize = BloomFilterUtils.getBitSize(numEntries, errorRate);
        int numHashs = BloomFilterUtils.getNumHashes(bitSize, numEntries);
        this.internalDynamicBloomFilter = new InternalDynamicBloomFilter(bitSize, numHashs, hashType, numEntries, maxNoOfEntries);
    }

    public HoodieDynamicBoundedBloomFilter(String serString) {
        byte[] bytes = Base64CodecUtil.decode(serString);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.internalDynamicBloomFilter = new InternalDynamicBloomFilter();
            this.internalDynamicBloomFilter.readFields(dis);
            dis.close();
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter instance", e);
        }
    }

    @Override
    public void add(String key) {
        this.add(StringUtils.getUTF8Bytes(key));
    }

    @Override
    public void add(byte[] keyBytes) {
        this.internalDynamicBloomFilter.add(new Key(keyBytes));
    }

    @Override
    public boolean mightContain(String key) {
        return this.internalDynamicBloomFilter.membershipTest(new Key(StringUtils.getUTF8Bytes(key)));
    }

    @Override
    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.internalDynamicBloomFilter.write(dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return Base64CodecUtil.encode(bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }

    @Override
    public BloomFilterTypeCode getBloomFilterTypeCode() {
        return BloomFilterTypeCode.DYNAMIC_V0;
    }
}

