/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.BloomFilterUtils;
import org.apache.hudi.common.bloom.InternalBloomFilter;
import org.apache.hudi.common.bloom.Key;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIndexException;

public class SimpleBloomFilter
implements BloomFilter {
    private InternalBloomFilter filter;

    public SimpleBloomFilter(int numEntries, double errorRate, int hashType) {
        int bitSize = BloomFilterUtils.getBitSize(numEntries, errorRate);
        int numHashs = BloomFilterUtils.getNumHashes(bitSize, numEntries);
        this.filter = new InternalBloomFilter(bitSize, numHashs, hashType);
    }

    public SimpleBloomFilter(String serString) {
        this.filter = new InternalBloomFilter();
        byte[] bytes = Base64CodecUtil.decode(serString);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.filter.readFields(dis);
            dis.close();
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter instance", e);
        }
    }

    @Override
    public void add(String key) {
        this.add(StringUtils.getUTF8Bytes(key));
    }

    @Override
    public void add(byte[] keyBytes) {
        if (keyBytes == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.filter.add(new Key(keyBytes));
    }

    @Override
    public boolean mightContain(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        return this.filter.membershipTest(new Key(StringUtils.getUTF8Bytes(key)));
    }

    @Override
    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.filter.write(dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return Base64CodecUtil.encode(bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.filter.write(os);
    }

    private void readObject(ObjectInputStream is) throws IOException {
        this.filter = new InternalBloomFilter();
        this.filter.readFields(is);
    }

    public void write(DataOutput out) throws IOException {
        out.write(StringUtils.getUTF8Bytes(this.filter.toString()));
    }

    public void readFields(DataInput in) throws IOException {
        this.filter = new InternalBloomFilter();
        this.filter.readFields(in);
    }

    @Override
    public BloomFilterTypeCode getBloomFilterTypeCode() {
        return BloomFilterTypeCode.SIMPLE;
    }
}

