/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ReflectionUtils;

public abstract class BootstrapIndex
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected final HoodieTableMetaClient metaClient;

    public BootstrapIndex(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
    }

    public abstract IndexReader createReader();

    public abstract IndexWriter createWriter(String var1);

    public abstract void dropIndex();

    public final boolean useIndex() {
        if (this.isPresent()) {
            boolean validInstantTime = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().map(i -> HoodieTimeline.compareTimestamps(i.getTimestamp(), HoodieTimeline.GREATER_THAN_OR_EQUALS, "00000000000001")).orElse(false);
            return validInstantTime && this.metaClient.getTableConfig().getBootstrapBasePath().isPresent();
        }
        return false;
    }

    protected abstract boolean isPresent();

    public static BootstrapIndex getBootstrapIndex(HoodieTableMetaClient metaClient) {
        return (BootstrapIndex)ReflectionUtils.loadClass(BootstrapIndexType.getBootstrapIndexClassName(metaClient.getTableConfig()), new Class[]{HoodieTableMetaClient.class}, new Object[]{metaClient});
    }

    public static abstract class IndexWriter
    implements AutoCloseable {
        protected final HoodieTableMetaClient metaClient;

        public IndexWriter(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
        }

        public abstract void begin();

        public abstract void appendNextPartition(String var1, List<BootstrapFileMapping> var2);

        public abstract void finish();

        @Override
        public abstract void close();
    }

    public static abstract class IndexReader
    implements Serializable,
    AutoCloseable {
        protected final HoodieTableMetaClient metaClient;

        public IndexReader(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
        }

        public abstract String getBootstrapBasePath();

        public abstract List<String> getIndexedPartitionPaths();

        public abstract List<HoodieFileGroupId> getIndexedFileGroupIds();

        public abstract List<BootstrapFileMapping> getSourceFileMappingForPartition(String var1);

        public abstract Map<HoodieFileGroupId, BootstrapFileMapping> getSourceFileMappingForFileIds(List<HoodieFileGroupId> var1);

        @Override
        public abstract void close();
    }
}

