/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public abstract class HoodieReaderContext<T> {
    public static final String INTERNAL_META_RECORD_KEY = "_0";
    public static final String INTERNAL_META_PARTITION_PATH = "_1";
    public static final String INTERNAL_META_ORDERING_FIELD = "_2";
    public static final String INTERNAL_META_OPERATION = "_3";
    public static final String INTERNAL_META_INSTANT_TIME = "_4";
    public static final String INTERNAL_META_SCHEMA = "_5";

    public abstract FileSystem getFs(String var1, Configuration var2);

    public abstract ClosableIterator<T> getFileRecordIterator(Path var1, long var2, long var4, Schema var6, Schema var7, Configuration var8);

    public abstract T convertAvroRecord(IndexedRecord var1);

    public abstract HoodieRecordMerger getRecordMerger(String var1);

    public abstract Object getValue(T var1, Schema var2, String var3);

    public abstract String getRecordKey(T var1, Schema var2);

    public abstract Comparable getOrderingValue(Option<T> var1, Map<String, Object> var2, Schema var3, TypedProperties var4);

    public abstract HoodieRecord<T> constructHoodieRecord(Option<T> var1, Map<String, Object> var2);

    public abstract T seal(T var1);

    public Map<String, Object> generateMetadataForRecord(String recordKey, String partitionPath, Comparable orderingVal) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put(INTERNAL_META_RECORD_KEY, recordKey);
        meta.put(INTERNAL_META_PARTITION_PATH, partitionPath);
        meta.put(INTERNAL_META_ORDERING_FIELD, orderingVal);
        return meta;
    }

    public Map<String, Object> generateMetadataForRecord(T record, Schema schema) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put(INTERNAL_META_RECORD_KEY, this.getRecordKey(record, schema));
        meta.put(INTERNAL_META_SCHEMA, schema);
        return meta;
    }

    public Map<String, Object> updateSchemaAndResetOrderingValInMetadata(Map<String, Object> meta, Schema schema) {
        meta.remove(INTERNAL_META_ORDERING_FIELD);
        meta.put(INTERNAL_META_SCHEMA, schema);
        return meta;
    }
}

