/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.bootstrap.index.NoOpBootstrapIndex;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;

@EnumDescription(value="Bootstrap index type to use for mapping between skeleton and actual data files.")
public enum BootstrapIndexType {
    HFILE(HFileBootstrapIndex.class.getName()),
    NO_OP(NoOpBootstrapIndex.class.getName());

    private final String className;

    private BootstrapIndexType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static BootstrapIndexType fromClassName(String className) {
        for (BootstrapIndexType type : BootstrapIndexType.values()) {
            if (!type.getClassName().equals(className)) continue;
            return type;
        }
        throw new IllegalArgumentException("No BootstrapIndexType found for class name: " + className);
    }

    public static String getBootstrapIndexClassName(HoodieConfig config) {
        if (!config.getBooleanOrDefault(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)) {
            return NO_OP.getClassName();
        }
        if (config.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)) {
            return config.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME);
        }
        if (config.contains(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)) {
            return BootstrapIndexType.valueOf(config.getString(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)).getClassName();
        }
        return BootstrapIndexType.getDefaultBootstrapIndexClassName(config);
    }

    public static String getDefaultBootstrapIndexClassName(HoodieConfig config) {
        if (!config.getBooleanOrDefault(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)) {
            return NO_OP.getClassName();
        }
        return BootstrapIndexType.valueOf(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE.defaultValue()).getClassName();
    }
}

