/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;

public class HoodieFileGroup
implements Serializable {
    private final HoodieFileGroupId fileGroupId;
    private final TreeMap<String, FileSlice> fileSlices;
    private final HoodieTimeline timeline;
    private final Option<HoodieInstant> lastInstant;

    public static Comparator<String> getReverseCommitTimeComparator() {
        return Comparator.reverseOrder();
    }

    public HoodieFileGroup(HoodieFileGroup fileGroup) {
        this.timeline = fileGroup.timeline;
        this.fileGroupId = fileGroup.fileGroupId;
        this.fileSlices = new TreeMap<String, FileSlice>((SortedMap<String, FileSlice>)fileGroup.fileSlices);
        this.lastInstant = fileGroup.lastInstant;
    }

    public HoodieFileGroup(String partitionPath, String id, HoodieTimeline timeline) {
        this(new HoodieFileGroupId(partitionPath, id), timeline);
    }

    public HoodieFileGroup(HoodieFileGroupId fileGroupId, HoodieTimeline timeline) {
        this.fileGroupId = fileGroupId;
        this.fileSlices = new TreeMap(HoodieFileGroup.getReverseCommitTimeComparator());
        this.timeline = timeline;
        this.lastInstant = timeline.lastInstant();
    }

    public void addNewFileSliceAtInstant(String baseInstantTime) {
        if (!this.fileSlices.containsKey(baseInstantTime)) {
            this.fileSlices.put(baseInstantTime, new FileSlice(this.fileGroupId, baseInstantTime));
        }
    }

    public void addBaseFile(HoodieBaseFile dataFile) {
        if (!this.fileSlices.containsKey(dataFile.getCommitTime())) {
            this.fileSlices.put(dataFile.getCommitTime(), new FileSlice(this.fileGroupId, dataFile.getCommitTime()));
        }
        this.fileSlices.get(dataFile.getCommitTime()).setBaseFile(dataFile);
    }

    public void addLogFile(CompletionTimeQueryView completionTimeQueryView, HoodieLogFile logFile) {
        String baseInstantTime = this.getBaseInstantTime(completionTimeQueryView, logFile);
        if (!this.fileSlices.containsKey(baseInstantTime)) {
            this.fileSlices.put(baseInstantTime, new FileSlice(this.fileGroupId, baseInstantTime));
        }
        this.fileSlices.get(baseInstantTime).addLogFile(logFile);
    }

    @VisibleForTesting
    public String getBaseInstantTime(CompletionTimeQueryView completionTimeQueryView, HoodieLogFile logFile) {
        if (this.fileSlices.isEmpty()) {
            return logFile.getDeltaCommitTime();
        }
        Option<String> completionTimeOpt = completionTimeQueryView.getCompletionTime(this.fileSlices.firstKey(), logFile.getDeltaCommitTime());
        if (completionTimeOpt.isPresent()) {
            for (String commitTime : this.fileSlices.keySet()) {
                if (!HoodieTimeline.compareTimestamps(completionTimeOpt.get(), HoodieTimeline.GREATER_THAN_OR_EQUALS, commitTime)) continue;
                return commitTime;
            }
            return logFile.getDeltaCommitTime();
        }
        return this.fileSlices.firstKey();
    }

    public String getPartitionPath() {
        return this.fileGroupId.getPartitionPath();
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    private boolean isFileSliceCommitted(FileSlice slice) {
        if (!HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, this.lastInstant.get().getTimestamp())) {
            return false;
        }
        return this.timeline.containsOrBeforeTimelineStarts(slice.getBaseInstantTime());
    }

    public Stream<FileSlice> getAllFileSlicesIncludingInflight() {
        return this.fileSlices.values().stream();
    }

    public Option<FileSlice> getLatestFileSlicesIncludingInflight() {
        return Option.fromJavaOptional(this.getAllFileSlicesIncludingInflight().findFirst());
    }

    public Stream<FileSlice> getAllFileSlices() {
        if (!this.timeline.empty()) {
            return this.fileSlices.values().stream().filter(this::isFileSliceCommitted);
        }
        return Stream.empty();
    }

    public Stream<FileSlice> getAllFileSlicesBeforeOn(String maxInstantTime) {
        return this.fileSlices.values().stream().filter(slice -> HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, maxInstantTime));
    }

    public Option<FileSlice> getLatestFileSlice() {
        return Option.fromJavaOptional(this.getAllFileSlices().findFirst());
    }

    public Option<HoodieBaseFile> getLatestDataFile() {
        return Option.fromJavaOptional(this.getAllBaseFiles().findFirst());
    }

    public Option<FileSlice> getLatestFileSliceBeforeOrOn(String maxInstantTime) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, maxInstantTime)).findFirst());
    }

    public Option<FileSlice> getLatestFileSliceBefore(String maxInstantTime) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN, maxInstantTime)).findFirst());
    }

    public Option<FileSlice> getLatestFileSliceInRange(List<String> commitRange) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> commitRange.contains(slice.getBaseInstantTime())).findFirst());
    }

    public Stream<HoodieBaseFile> getAllBaseFiles() {
        return this.getAllFileSlices().filter(slice -> slice.getBaseFile().isPresent()).map(slice -> slice.getBaseFile().get());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieFileGroup {");
        sb.append("id=").append(this.fileGroupId);
        sb.append(", fileSlices='").append(this.fileSlices).append('\'');
        sb.append(", lastInstant='").append(this.lastInstant).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void addFileSlice(FileSlice slice) {
        this.fileSlices.put(slice.getBaseInstantTime(), slice);
    }

    public Stream<FileSlice> getAllRawFileSlices() {
        return this.fileSlices.values().stream();
    }

    public HoodieTimeline getTimeline() {
        return this.timeline;
    }
}

