/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hudi.common.model.HoodieFunctionalIndexDefinition;
import org.apache.hudi.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieFunctionalIndexMetadata
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieFunctionalIndexMetadata.class);
    private Map<String, HoodieFunctionalIndexDefinition> indexDefinitions;

    public HoodieFunctionalIndexMetadata() {
        this.indexDefinitions = new HashMap<String, HoodieFunctionalIndexDefinition>();
    }

    public HoodieFunctionalIndexMetadata(Map<String, HoodieFunctionalIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public Map<String, HoodieFunctionalIndexDefinition> getIndexDefinitions() {
        return this.indexDefinitions;
    }

    public void setIndexDefinitions(Map<String, HoodieFunctionalIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public String toJson() throws JsonProcessingException {
        if (this.indexDefinitions.containsKey(null)) {
            LOG.info("null index name for the index definition " + this.indexDefinitions.get(null));
            this.indexDefinitions.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public static HoodieFunctionalIndexMetadata fromJson(String json) throws IOException {
        if (json == null || json.isEmpty()) {
            return new HoodieFunctionalIndexMetadata();
        }
        return JsonUtils.getObjectMapper().readValue(json, HoodieFunctionalIndexMetadata.class);
    }

    public String toString() {
        return "HoodieFunctionalIndexMetadata{indexDefinitions=" + this.indexDefinitions + '}';
    }
}

