/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.metadata.HoodieMetadataPayload;

@EnumDescription(value="Payload to use for merging records")
public enum RecordPayloadType {
    AWS_DMS_AVRO(AWSDmsAvroPayload.class.getName()),
    HOODIE_AVRO(HoodieAvroPayload.class.getName()),
    HOODIE_AVRO_DEFAULT(DefaultHoodieRecordPayload.class.getName()),
    EVENT_TIME_AVRO(EventTimeAvroPayload.class.getName()),
    OVERWRITE_NON_DEF_LATEST_AVRO(OverwriteNonDefaultsWithLatestAvroPayload.class.getName()),
    OVERWRITE_LATEST_AVRO(OverwriteWithLatestAvroPayload.class.getName()),
    PARTIAL_UPDATE_AVRO(PartialUpdateAvroPayload.class.getName()),
    MYSQL_DEBEZIUM_AVRO(MySqlDebeziumAvroPayload.class.getName()),
    POSTGRES_DEBEZIUM_AVRO(PostgresDebeziumAvroPayload.class.getName()),
    HOODIE_METADATA(HoodieMetadataPayload.class.getName()),
    VALIDATE_DUPLICATE_AVRO("org.apache.spark.sql.hudi.command.ValidateDuplicateKeyPayload"),
    EXPRESSION_AVRO("org.apache.spark.sql.hudi.command.payload.ExpressionPayload"),
    CUSTOM("");

    private String className;

    private RecordPayloadType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static RecordPayloadType fromClassName(String className) {
        for (RecordPayloadType type : RecordPayloadType.values()) {
            if (!type.getClassName().equals(className)) continue;
            return type;
        }
        RecordPayloadType.CUSTOM.className = className;
        return CUSTOM;
    }

    public static String getPayloadClassName(HoodieConfig config) {
        String payloadClassName = config.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME) ? config.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME) : (config.contains(HoodieTableConfig.PAYLOAD_TYPE) ? RecordPayloadType.valueOf(config.getString(HoodieTableConfig.PAYLOAD_TYPE)).getClassName() : (config.contains("hoodie.datasource.write.payload.class") != false ? config.getString("hoodie.datasource.write.payload.class") : RecordPayloadType.valueOf(HoodieTableConfig.PAYLOAD_TYPE.defaultValue()).getClassName()));
        return payloadClassName.replace("com.uber.hoodie", "org.apache.hudi");
    }
}

