/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergedLogRecordReader<T>
extends BaseHoodieLogRecordReader<T>
implements Iterable<Pair<Option<T>, Map<String, Object>>>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergedLogRecordReader.class);
    public final HoodieTimer timer = HoodieTimer.create();
    private final Set<String> scannedPrefixes = new HashSet<String>();
    private long numMergedRecordsInLog;
    private long totalTimeTakenToReadAndMergeBlocks;

    private HoodieMergedLogRecordReader(HoodieReaderContext<T> readerContext, FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean readBlocksLazily, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionName, InternalSchema internalSchema, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieRecordMerger recordMerger, HoodieFileGroupRecordBuffer<T> recordBuffer) {
        super(readerContext, fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize, instantRange, withOperationField, forceFullScan, partitionName, internalSchema, keyFieldOverride, enableOptimizedLogBlocksScan, recordMerger, recordBuffer);
        if (forceFullScan) {
            this.performScan();
        }
    }

    public final void scan() {
        this.scan(false);
    }

    public final void scan(boolean skipProcessingBlocks) {
        if (this.forceFullScan) {
            return;
        }
        this.scanInternal(Option.empty(), skipProcessingBlocks);
    }

    public void scanByFullKeys(List<String> keys) {
        if (this.forceFullScan) {
            return;
        }
        List<String> missingKeys = keys.stream().filter(key -> !this.recordBuffer.containsLogRecord((String)key)).collect(Collectors.toList());
        if (missingKeys.isEmpty()) {
            return;
        }
        this.scanInternal(Option.of(KeySpec.fullKeySpec(missingKeys)), false);
    }

    public void scanByKeyPrefixes(List<String> keyPrefixes) {
        if (this.forceFullScan) {
            return;
        }
        List<String> missingKeyPrefixes = keyPrefixes.stream().filter(keyPrefix -> this.scannedPrefixes.stream().noneMatch(keyPrefix::startsWith)).collect(Collectors.toList());
        if (missingKeyPrefixes.isEmpty()) {
            return;
        }
        this.scanInternal(Option.of(KeySpec.prefixKeySpec(missingKeyPrefixes)), false);
        this.scannedPrefixes.addAll(missingKeyPrefixes);
    }

    private void performScan() {
        this.timer.startTimer();
        this.scanInternal(Option.empty(), false);
        this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
        this.numMergedRecordsInLog = this.recordBuffer.size();
        LOG.info("Number of log files scanned => " + this.logFilePaths.size());
        LOG.info("Number of entries in Map => " + this.recordBuffer.size());
    }

    @Override
    public Iterator<Pair<Option<T>, Map<String, Object>>> iterator() {
        return this.recordBuffer.getLogRecordIterator();
    }

    public Map<Object, Pair<Option<T>, Map<String, Object>>> getRecords() {
        return this.recordBuffer.getLogRecords();
    }

    public HoodieRecord.HoodieRecordType getRecordType() {
        return this.recordMerger.getRecordType();
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }

    @Override
    public void close() {
    }

    public static class Builder<T>
    extends BaseHoodieLogRecordReader.Builder<T> {
        private HoodieReaderContext<T> readerContext;
        private FileSystem fs;
        private String basePath;
        private List<String> logFilePaths;
        private Schema readerSchema;
        private InternalSchema internalSchema = InternalSchema.getEmptyInternalSchema();
        private String latestInstantTime;
        private boolean readBlocksLazily;
        private boolean reverseReader;
        private int bufferSize;
        private Long maxMemorySizeInBytes;
        private Option<InstantRange> instantRange = Option.empty();
        private String partitionName;
        private boolean withOperationField = false;
        private String keyFieldOverride;
        private boolean forceFullScan = true;
        private boolean enableOptimizedLogBlocksScan = false;
        private HoodieRecordMerger recordMerger = HoodiePreCombineAvroRecordMerger.INSTANCE;
        private HoodieFileGroupRecordBuffer<T> recordBuffer;

        @Override
        public Builder<T> withHoodieReaderContext(HoodieReaderContext<T> readerContext) {
            this.readerContext = readerContext;
            return this;
        }

        @Override
        public Builder<T> withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder<T> withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder<T> withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths.stream().filter(p -> !p.endsWith(".cdc")).collect(Collectors.toList());
            return this;
        }

        @Override
        public Builder<T> withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder<T> withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder<T> withReadBlocksLazily(boolean readBlocksLazily) {
            this.readBlocksLazily = readBlocksLazily;
            return this;
        }

        @Override
        public Builder<T> withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder<T> withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder<T> withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        @Override
        public Builder<T> withInternalSchema(InternalSchema internalSchema) {
            this.internalSchema = internalSchema;
            return this;
        }

        @Override
        public Builder<T> withOperationField(boolean withOperationField) {
            this.withOperationField = withOperationField;
            return this;
        }

        @Override
        public Builder<T> withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public Builder<T> withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
            return this;
        }

        @Override
        public Builder<T> withRecordMerger(HoodieRecordMerger recordMerger) {
            this.recordMerger = HoodieRecordUtils.mergerToPreCombineMode(recordMerger);
            return this;
        }

        public Builder<T> withKeyFiledOverride(String keyFieldOverride) {
            this.keyFieldOverride = Objects.requireNonNull(keyFieldOverride);
            return this;
        }

        public Builder<T> withForceFullScan(boolean forceFullScan) {
            this.forceFullScan = forceFullScan;
            return this;
        }

        public Builder<T> withRecordBuffer(HoodieFileGroupRecordBuffer<T> recordBuffer) {
            this.recordBuffer = recordBuffer;
            return this;
        }

        @Override
        public HoodieMergedLogRecordReader<T> build() {
            if (this.partitionName == null && CollectionUtils.nonEmpty(this.logFilePaths)) {
                this.partitionName = FSUtils.getRelativePartitionPath(new Path(this.basePath), new Path(this.logFilePaths.get(0)).getParent());
            }
            ValidationUtils.checkArgument(this.recordMerger != null);
            ValidationUtils.checkArgument(this.recordBuffer != null);
            return new HoodieMergedLogRecordReader(this.readerContext, this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.instantRange, this.withOperationField, this.forceFullScan, Option.ofNullable(this.partitionName), this.internalSchema, Option.ofNullable(this.keyFieldOverride), this.enableOptimizedLogBlocksScan, this.recordMerger, this.recordBuffer);
        }
    }
}

