/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieDeleteRecord;
import org.apache.hudi.avro.model.HoodieDeleteRecordList;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.io.BinaryDecoder;
import org.apache.hudi.org.apache.avro.io.BinaryEncoder;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;
import org.apache.hudi.org.apache.avro.io.EncoderFactory;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumReader;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieDeleteBlock
extends HoodieLogBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieDeleteBlock.class);
    private static final Lazy<HoodieDeleteRecordList.Builder> HOODIE_DELETE_RECORD_LIST_BUILDER_STUB = Lazy.lazily(HoodieDeleteRecordList::newBuilder);
    private static final Lazy<HoodieDeleteRecord.Builder> HOODIE_DELETE_RECORD_BUILDER_STUB = Lazy.lazily(HoodieDeleteRecord::newBuilder);
    private final boolean shouldWriteRecordPositions;
    private DeleteRecord[] recordsToDelete;

    public HoodieDeleteBlock(List<Pair<DeleteRecord, Long>> recordsToDelete, boolean shouldWriteRecordPositions, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(Option.empty(), null, false, Option.empty(), header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), shouldWriteRecordPositions);
        if (shouldWriteRecordPositions && !recordsToDelete.isEmpty()) {
            recordsToDelete.sort((o1, o2) -> {
                long v1 = (Long)o1.getRight();
                long v2 = (Long)o2.getRight();
                return Long.compare(v1, v2);
            });
            if (HoodieRecordLocation.isPositionValid(recordsToDelete.get(0).getRight())) {
                this.addRecordPositionsToHeader(recordsToDelete.stream().map(Pair::getRight).collect(Collectors.toSet()), recordsToDelete.size());
            } else {
                LOG.warn("There are delete records without valid positions. Skip writing record positions to the delete block header.");
            }
        }
        this.recordsToDelete = (DeleteRecord[])recordsToDelete.stream().map(Pair::getLeft).toArray(DeleteRecord[]::new);
    }

    public HoodieDeleteBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        this(content, inputStream, readBlockLazily, blockContentLocation, header, footer, false);
    }

    HoodieDeleteBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, boolean shouldWriteRecordPositions) {
        super(header, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.shouldWriteRecordPositions = shouldWriteRecordPositions;
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        Option<byte[]> content = this.getContent();
        if (content.isPresent()) {
            return content.get();
        }
        if (this.readBlockLazily && this.recordsToDelete == null) {
            this.getRecordsToDelete();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(version);
        byte[] bytesToWrite = version <= 2 ? this.serializeV2() : this.serializeV3();
        output.writeInt(bytesToWrite.length);
        output.write(bytesToWrite);
        return baos.toByteArray();
    }

    public DeleteRecord[] getRecordsToDelete() {
        try {
            if (this.recordsToDelete == null) {
                if (!this.getContent().isPresent() && this.readBlockLazily) {
                    this.inflate();
                }
                SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.getContent().get())));
                int version = dis.readInt();
                int dataLength = dis.readInt();
                byte[] data = new byte[dataLength];
                dis.readFully(data);
                this.recordsToDelete = HoodieDeleteBlock.deserialize(version, data);
                this.deflate();
            }
            return this.recordsToDelete;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to generate keys to delete from block content", io);
        }
    }

    private byte[] serializeV2() throws IOException {
        return SerializationUtils.serialize(this.getRecordsToDelete());
    }

    private byte[] serializeV3() throws IOException {
        SpecificDatumWriter<HoodieDeleteRecordList> writer = new SpecificDatumWriter<HoodieDeleteRecordList>(HoodieDeleteRecordList.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(baos, null);
        HoodieDeleteRecordList.Builder recordListBuilder = HOODIE_DELETE_RECORD_LIST_BUILDER_STUB.get();
        HoodieDeleteRecord.Builder recordBuilder = HOODIE_DELETE_RECORD_BUILDER_STUB.get();
        List<HoodieDeleteRecord> deleteRecordList = Arrays.stream(this.getRecordsToDelete()).map(record -> HoodieDeleteRecord.newBuilder(recordBuilder).setRecordKey(record.getRecordKey()).setPartitionPath(record.getPartitionPath()).setOrderingVal(HoodieAvroUtils.wrapValueIntoAvro(record.getOrderingValue())).build()).collect(Collectors.toList());
        writer.write(HoodieDeleteRecordList.newBuilder(recordListBuilder).setDeleteRecordList(deleteRecordList).build(), encoder);
        encoder.flush();
        return baos.toByteArray();
    }

    private static DeleteRecord[] deserialize(int version, byte[] data) throws IOException {
        if (version == 1) {
            HoodieKey[] keys = (HoodieKey[])SerializationUtils.deserialize(data);
            return (DeleteRecord[])Arrays.stream(keys).map(DeleteRecord::create).toArray(DeleteRecord[]::new);
        }
        if (version == 2) {
            return (DeleteRecord[])SerializationUtils.deserialize(data);
        }
        SpecificDatumReader<HoodieDeleteRecordList> reader = new SpecificDatumReader<HoodieDeleteRecordList>(HoodieDeleteRecordList.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, 0, data.length, null);
        List<HoodieDeleteRecord> deleteRecordList = ((HoodieDeleteRecordList)reader.read(null, decoder)).getDeleteRecordList();
        return (DeleteRecord[])deleteRecordList.stream().map(record -> DeleteRecord.create(record.getRecordKey(), record.getPartitionPath(), HoodieAvroUtils.unwrapAvroValueWrapper(record.getOrderingVal()))).toArray(DeleteRecord[]::new);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.DELETE_BLOCK;
    }
}

