/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.org.apache.avro.Schema;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public abstract class HoodieBaseFileGroupRecordBuffer<T>
implements HoodieFileGroupRecordBuffer<T> {
    protected final HoodieReaderContext<T> readerContext;
    protected final Schema readerSchema;
    protected final Schema baseFileSchema;
    protected final Option<String> partitionNameOverrideOpt;
    protected final Option<String[]> partitionPathFieldOpt;
    protected final HoodieRecordMerger recordMerger;
    protected final TypedProperties payloadProps;
    protected final Map<Object, Pair<Option<T>, Map<String, Object>>> records;
    protected ClosableIterator<T> baseFileIterator;
    protected Iterator<Pair<Option<T>, Map<String, Object>>> logRecordIterator;
    protected T nextRecord;
    protected boolean enablePartialMerging = false;

    public HoodieBaseFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, Schema readerSchema, Schema baseFileSchema, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, HoodieRecordMerger recordMerger, TypedProperties payloadProps) {
        this.readerContext = readerContext;
        this.readerSchema = readerSchema;
        this.baseFileSchema = baseFileSchema;
        this.partitionNameOverrideOpt = partitionNameOverrideOpt;
        this.partitionPathFieldOpt = partitionPathFieldOpt;
        this.recordMerger = recordMerger;
        this.payloadProps = payloadProps;
        this.records = new HashMap<Object, Pair<Option<T>, Map<String, Object>>>();
    }

    @Override
    public void setBaseFileIterator(ClosableIterator<T> baseFileIterator) {
        this.baseFileIterator = baseFileIterator;
    }

    protected abstract boolean doHasNext() throws IOException;

    @Override
    public final boolean hasNext() throws IOException {
        return this.nextRecord != null || this.doHasNext();
    }

    @Override
    public final T next() {
        T record = this.nextRecord;
        this.nextRecord = null;
        return record;
    }

    @Override
    public Map<Object, Pair<Option<T>, Map<String, Object>>> getLogRecords() {
        return this.records;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public Iterator<Pair<Option<T>, Map<String, Object>>> getLogRecordIterator() {
        return this.records.values().iterator();
    }

    @Override
    public void close() {
        this.records.clear();
    }

    protected Option<Pair<T, Map<String, Object>>> doProcessNextDataRecord(T record, Map<String, Object> metadata, Pair<Option<T>, Map<String, Object>> existingRecordMetadataPair) throws IOException {
        if (existingRecordMetadataPair != null) {
            Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt;
            Option<Pair<HoodieRecord, Schema>> option = combinedRecordAndSchemaOpt = this.enablePartialMerging ? this.recordMerger.partialMerge(this.readerContext.constructHoodieRecord(Option.of(record), metadata), (Schema)metadata.get("_5"), this.readerContext.constructHoodieRecord(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight()), (Schema)existingRecordMetadataPair.getRight().get("_5"), this.readerSchema, this.payloadProps) : this.recordMerger.merge(this.readerContext.constructHoodieRecord(Option.of(record), metadata), (Schema)metadata.get("_5"), this.readerContext.constructHoodieRecord(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight()), (Schema)existingRecordMetadataPair.getRight().get("_5"), this.payloadProps);
            if (!combinedRecordAndSchemaOpt.isPresent()) {
                return Option.empty();
            }
            Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
            HoodieRecord combinedRecord = combinedRecordAndSchema.getLeft();
            if (combinedRecord.getData() != existingRecordMetadataPair.getLeft().get()) {
                return Option.of(Pair.of(combinedRecord.getData(), this.enablePartialMerging ? this.readerContext.updateSchemaAndResetOrderingValInMetadata(metadata, combinedRecordAndSchema.getRight()) : metadata));
            }
            return Option.empty();
        }
        return Option.of(Pair.of(record, metadata));
    }

    protected Option<DeleteRecord> doProcessNextDeletedRecord(DeleteRecord deleteRecord, Pair<Option<T>, Map<String, Object>> existingRecordMetadataPair) {
        if (existingRecordMetadataPair != null) {
            boolean chooseExisting;
            Comparable existingOrderingVal = this.readerContext.getOrderingValue(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight(), this.readerSchema, this.payloadProps);
            Comparable<?> deleteOrderingVal = deleteRecord.getOrderingValue();
            boolean bl = chooseExisting = !deleteOrderingVal.equals(0) && ReflectionUtils.isSameClass(existingOrderingVal, deleteOrderingVal) && existingOrderingVal.compareTo(deleteOrderingVal) > 0;
            if (chooseExisting) {
                return Option.empty();
            }
        }
        return Option.of(deleteRecord);
    }

    protected Pair<ClosableIterator<T>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        ClosableIterator<T> blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = keySpecOpt.get();
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext, keySpec.getKeys(), keySpec.isFullKey());
        } else {
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext);
        }
        return Pair.of(blockRecordsIterator, dataBlock.getSchema());
    }

    protected Option<T> merge(Option<T> older, Map<String, Object> olderInfoMap, Option<T> newer, Map<String, Object> newerInfoMap) throws IOException {
        if (!older.isPresent()) {
            return newer;
        }
        Option<Pair<HoodieRecord, Schema>> mergedRecord = this.enablePartialMerging ? this.recordMerger.partialMerge(this.readerContext.constructHoodieRecord(older, olderInfoMap), (Schema)olderInfoMap.get("_5"), this.readerContext.constructHoodieRecord(newer, newerInfoMap), (Schema)newerInfoMap.get("_5"), this.readerSchema, this.payloadProps) : this.recordMerger.merge(this.readerContext.constructHoodieRecord(older, olderInfoMap), (Schema)olderInfoMap.get("_5"), this.readerContext.constructHoodieRecord(newer, newerInfoMap), (Schema)newerInfoMap.get("_5"), this.payloadProps);
        if (mergedRecord.isPresent()) {
            return Option.ofNullable(mergedRecord.get().getLeft().getData());
        }
        return Option.empty();
    }

    protected boolean shouldSkip(T record, String keyFieldName, boolean isFullKey, Set<String> keys) {
        block6: {
            block5: {
                String recordKey = this.readerContext.getValue(record, this.readerSchema, keyFieldName).toString();
                if (recordKey == null || recordKey.isEmpty()) {
                    throw new HoodieKeyException("Can not extract the key for a record");
                }
                if (keys.isEmpty()) {
                    return false;
                }
                if (isFullKey && keys.contains(recordKey)) break block5;
                if (isFullKey) break block6;
                if (!keys.stream().anyMatch(recordKey::startsWith)) break block6;
            }
            return false;
        }
        return true;
    }

    protected static List<Long> extractRecordPositions(HoodieLogBlock logBlock) throws IOException {
        ArrayList<Long> blockPositions = new ArrayList<Long>();
        Roaring64NavigableMap positions = logBlock.getRecordPositions();
        if (positions == null || positions.isEmpty()) {
            throw new HoodieValidationException("No record position info is found when attempt to do position based merge.");
        }
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            blockPositions.add((Long)iterator.next());
        }
        if (blockPositions.isEmpty()) {
            throw new HoodieCorruptedDataException("No positions are extracted.");
        }
        return blockPositions;
    }
}

