/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordReader;
import org.apache.hudi.common.table.read.HoodieFileGroupReaderState;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodiePositionBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.EmptyIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;

public final class HoodieFileGroupReader<T>
implements Closeable {
    private final HoodieReaderContext<T> readerContext;
    private final Option<HoodieBaseFile> baseFilePath;
    private final Option<List<String>> logFilePathList;
    private final Configuration hadoopConf;
    private final TypedProperties props;
    private final long start;
    private final long length;
    private final HoodieFileGroupRecordBuffer<T> recordBuffer;
    private final HoodieFileGroupReaderState readerState = new HoodieFileGroupReaderState();
    private ClosableIterator<T> baseFileIterator;
    private HoodieRecordMerger recordMerger;

    public HoodieFileGroupReader(HoodieReaderContext<T> readerContext, HoodieTableMetaClient metaClient, String fileGroupId, TypedProperties props, HoodieTimeline timeline, HoodieTableQueryType queryType, Option<String> instantTime, Option<String> startInstantTime, boolean shouldUseRecordPosition) throws Exception {
        this(readerContext, metaClient.getHadoopConf(), metaClient.getBasePathV2().toString(), instantTime.get(), Option.empty(), Option.empty(), new TableSchemaResolver(metaClient).getTableAvroSchema(), props, 0L, Long.MAX_VALUE, shouldUseRecordPosition);
    }

    public HoodieFileGroupReader(HoodieReaderContext<T> readerContext, Configuration hadoopConf, String tablePath, String latestCommitTime, Option<HoodieBaseFile> baseFilePath, Option<List<String>> logFilePathList, Schema avroSchema, TypedProperties props, long start, long length, boolean shouldUseRecordPosition) {
        this.readerContext = readerContext;
        this.hadoopConf = hadoopConf;
        this.baseFilePath = baseFilePath;
        this.logFilePathList = logFilePathList;
        this.props = props;
        this.start = start;
        this.length = length;
        this.recordMerger = readerContext.getRecordMerger(ConfigUtils.getStringWithAltKeys((Properties)props, HoodieTableConfig.RECORD_MERGER_STRATEGY, HoodieTableConfig.RECORD_MERGER_STRATEGY.defaultValue()));
        this.readerState.tablePath = tablePath;
        this.readerState.latestCommitTime = latestCommitTime;
        this.readerState.baseFileAvroSchema = avroSchema;
        this.readerState.logRecordAvroSchema = avroSchema;
        this.readerState.mergeProps.putAll((Map<?, ?>)props);
        String filePath = baseFilePath.isPresent() ? baseFilePath.get().getPath() : logFilePathList.get().get(0);
        String partitionPath = FSUtils.getRelativePartitionPath(new Path(tablePath), new Path(filePath).getParent());
        Option<String> partitionNameOpt = StringUtils.isNullOrEmpty(partitionPath) ? Option.empty() : Option.of(partitionPath);
        Option<Object> partitionConfigValue = ConfigUtils.getRawValueWithAltKeys(props, HoodieTableConfig.PARTITION_FIELDS);
        Option<String[]> partitionPathFieldOpt = partitionConfigValue.isPresent() ? Option.of(Arrays.stream(partitionConfigValue.get().toString().split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0])) : Option.empty();
        this.recordBuffer = shouldUseRecordPosition ? new HoodiePositionBasedFileGroupRecordBuffer<T>(readerContext, avroSchema, avroSchema, partitionNameOpt, partitionPathFieldOpt, this.recordMerger, props) : new HoodieKeyBasedFileGroupRecordBuffer<T>(readerContext, avroSchema, avroSchema, partitionNameOpt, partitionPathFieldOpt, this.recordMerger, props);
    }

    public void initRecordIterators() {
        this.baseFileIterator = this.baseFilePath.isPresent() ? this.readerContext.getFileRecordIterator(this.baseFilePath.get().getHadoopPath(), this.start, this.length, this.readerState.baseFileAvroSchema, this.readerState.baseFileAvroSchema, this.hadoopConf) : new EmptyIterator<T>();
        this.scanLogFiles();
        this.recordBuffer.setBaseFileIterator(this.baseFileIterator);
    }

    public boolean hasNext() throws IOException {
        return this.recordBuffer.hasNext();
    }

    public T next() {
        return this.recordBuffer.next();
    }

    private void scanLogFiles() {
        if (this.logFilePathList.isPresent()) {
            String path = this.baseFilePath.isPresent() ? this.baseFilePath.get().getPath() : this.logFilePathList.get().get(0);
            FileSystem fs = this.readerContext.getFs(path, this.hadoopConf);
            BaseHoodieLogRecordReader logRecordReader = ((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)HoodieMergedLogRecordReader.newBuilder().withHoodieReaderContext((HoodieReaderContext)this.readerContext)).withFileSystem(fs)).withBasePath(this.readerState.tablePath)).withLogFilePaths((List)this.logFilePathList.get())).withLatestInstantTime(this.readerState.latestCommitTime)).withReaderSchema(this.readerState.logRecordAvroSchema)).withReadBlocksLazily(ConfigUtils.getBooleanWithAltKeys(this.props, HoodieReaderConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE))).withReverseReader(false)).withBufferSize(ConfigUtils.getIntWithAltKeys(this.props, HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE))).withPartition(FSUtils.getRelativePartitionPath(new Path(this.readerState.tablePath), new Path(this.logFilePathList.get().get(0)).getParent()))).withRecordMerger(this.recordMerger)).withRecordBuffer(this.recordBuffer).build();
            ((HoodieMergedLogRecordReader)logRecordReader).close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.baseFileIterator != null) {
            this.baseFileIterator.close();
        }
        if (this.recordBuffer != null) {
            this.recordBuffer.close();
        }
    }

    public HoodieFileGroupReaderIterator<T> getClosableIterator() {
        return new HoodieFileGroupReaderIterator(this);
    }

    public static class HoodieFileGroupReaderIterator<T>
    implements ClosableIterator<T> {
        private final HoodieFileGroupReader<T> reader;

        public HoodieFileGroupReaderIterator(HoodieFileGroupReader<T> reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to read record", e);
            }
        }

        @Override
        public T next() {
            return this.reader.next();
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to close the reader", e);
            }
        }
    }
}

