/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.HoodieBaseFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieKeyBasedFileGroupRecordBuffer<T>
extends HoodieBaseFileGroupRecordBuffer<T> {
    public HoodieKeyBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, Schema readerSchema, Schema baseFileSchema, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, HoodieRecordMerger recordMerger, TypedProperties payloadProps) {
        super(readerContext, readerSchema, baseFileSchema, partitionNameOverrideOpt, partitionPathFieldOpt, recordMerger, payloadProps);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.KEY_BASED;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(nextRecord, recordsIteratorSchemaPair.getRight());
                String recordKey = (String)metadata.get("_0");
                this.processNextDataRecord(nextRecord, metadata, recordKey);
            }
        }
    }

    @Override
    public void processNextDataRecord(T record, Map<String, Object> metadata, Object recordKey) throws IOException {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordKey);
        Option<Pair<T, Map<String, Object>>> mergedRecordAndMetadata = this.doProcessNextDataRecord(record, metadata, existingRecordMetadataPair);
        if (mergedRecordAndMetadata.isPresent()) {
            this.records.put(recordKey, Pair.of(Option.ofNullable(this.readerContext.seal(mergedRecordAndMetadata.get().getLeft())), mergedRecordAndMetadata.get().getRight()));
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            String recordKey = record.getRecordKey();
            this.processNextDeletedRecord(record, recordKey);
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Object recordKey) {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordKey);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecordMetadataPair);
        if (recordOpt.isPresent()) {
            this.records.put(recordKey, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord((String)recordKey, recordOpt.get().getPartitionPath(), recordOpt.get().getOrderingValue())));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState(this.baseFileIterator != null, "Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            Object baseRecord = this.baseFileIterator.next();
            String recordKey = this.readerContext.getRecordKey(baseRecord, this.baseFileSchema);
            Pair logRecordInfo = (Pair)this.records.remove(recordKey);
            Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(baseRecord, this.baseFileSchema);
            Option<Object> resultRecord = logRecordInfo != null ? this.merge(Option.of(baseRecord), metadata, (Option)logRecordInfo.getLeft(), (Map)logRecordInfo.getRight()) : this.merge(Option.empty(), Collections.emptyMap(), Option.of(baseRecord), metadata);
            if (!resultRecord.isPresent()) continue;
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        if (this.logRecordIterator == null) {
            this.logRecordIterator = this.records.values().iterator();
        }
        while (this.logRecordIterator.hasNext()) {
            Pair nextRecordInfo = (Pair)this.logRecordIterator.next();
            Option resultRecord = this.merge(Option.empty(), Collections.emptyMap(), (Option)nextRecordInfo.getLeft(), (Map)nextRecordInfo.getRight());
            if (!resultRecord.isPresent()) continue;
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        return false;
    }
}

