/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.HoodieBaseFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodiePositionBasedFileGroupRecordBuffer<T>
extends HoodieBaseFileGroupRecordBuffer<T> {
    private long nextRecordPosition = 0L;

    public HoodiePositionBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, Schema readerSchema, Schema baseFileSchema, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, HoodieRecordMerger recordMerger, TypedProperties payloadProps) {
        super(readerContext, readerSchema, baseFileSchema, partitionNameOverrideOpt, partitionPathFieldOpt, recordMerger, payloadProps);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.POSITION_BASED;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        HashSet<String> keys = new HashSet();
        boolean isFullKey = true;
        if (keySpecOpt.isPresent()) {
            if (!keySpecOpt.get().getKeys().isEmpty()) {
                keys = new HashSet<String>(keySpecOpt.get().getKeys());
            }
            isFullKey = keySpecOpt.get().isFullKey();
        }
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        List<Long> recordPositions = HoodiePositionBasedFileGroupRecordBuffer.extractRecordPositions(dataBlock);
        try (ClosableIterator recordIterator = dataBlock.getEngineRecordIterator(this.readerContext);){
            int recordIndex = 0;
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                if (this.shouldSkip(nextRecord, dataBlock.getKeyFieldName(), isFullKey, keys)) {
                    ++recordIndex;
                    continue;
                }
                long recordPosition = recordPositions.get(recordIndex++);
                this.processNextDataRecord(nextRecord, this.readerContext.generateMetadataForRecord(nextRecord, this.readerSchema), recordPosition);
            }
        }
    }

    @Override
    public void processNextDataRecord(T record, Map<String, Object> metadata, Object recordPosition) throws IOException {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordPosition);
        Option<Pair<T, Map<String, Object>>> mergedRecordAndMetadata = this.doProcessNextDataRecord(record, metadata, existingRecordMetadataPair);
        if (mergedRecordAndMetadata.isPresent()) {
            this.records.put(recordPosition, Pair.of(Option.ofNullable(this.readerContext.seal(mergedRecordAndMetadata.get().getLeft())), mergedRecordAndMetadata.get().getRight()));
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        List<Long> recordPositions = HoodiePositionBasedFileGroupRecordBuffer.extractRecordPositions(deleteBlock);
        if (this.recordMerger.getMergingStrategy().equals("eeb8d96f-b1e4-49fd-bbf8-28ac514178e5")) {
            for (Long recordPosition : recordPositions) {
                this.records.put(recordPosition, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord(null, "", Integer.valueOf(0))));
            }
            return;
        }
        int recordIndex = 0;
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            long recordPosition = recordPositions.get(recordIndex++);
            this.processNextDeletedRecord(record, recordPosition);
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Object recordPosition) {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordPosition);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecordMetadataPair);
        if (recordOpt.isPresent()) {
            String recordKey = recordOpt.get().getRecordKey();
            this.records.put(recordPosition, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord(recordKey, recordOpt.get().getPartitionPath(), recordOpt.get().getOrderingValue())));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.values().stream().filter(r -> ((Option)r.getLeft()).isPresent()).map(r -> this.readerContext.getRecordKey(((Option)r.getKey()).get(), this.readerSchema)).anyMatch(recordKey::equals);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState(this.baseFileIterator != null, "Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            Object baseRecord = this.baseFileIterator.next();
            Pair logRecordInfo = (Pair)this.records.remove(this.nextRecordPosition++);
            Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(baseRecord, this.baseFileSchema);
            Option<Object> resultRecord = logRecordInfo != null ? this.merge(Option.of(baseRecord), metadata, (Option)logRecordInfo.getLeft(), (Map)logRecordInfo.getRight()) : this.merge(Option.empty(), Collections.emptyMap(), Option.of(baseRecord), metadata);
            if (!resultRecord.isPresent()) continue;
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        if (this.logRecordIterator == null) {
            this.logRecordIterator = this.records.values().iterator();
        }
        while (this.logRecordIterator.hasNext()) {
            Pair nextRecordInfo = (Pair)this.logRecordIterator.next();
            Option resultRecord = this.merge(Option.empty(), Collections.emptyMap(), (Option)nextRecordInfo.getLeft(), (Map)nextRecordInfo.getRight());
            if (!resultRecord.isPresent()) continue;
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        return false;
    }
}

