/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

public class ActiveAction
implements Serializable,
Comparable<ActiveAction> {
    private final HoodieInstant requested;
    private final HoodieInstant inflight;
    private final HoodieInstant completed;

    protected ActiveAction(@Nullable HoodieInstant requested, @Nullable HoodieInstant inflight, HoodieInstant completed) {
        this.requested = requested;
        this.inflight = inflight;
        this.completed = completed;
    }

    public static ActiveAction fromInstants(List<HoodieInstant> instants) {
        ValidationUtils.checkArgument(instants.size() <= 3);
        HoodieInstant requested = null;
        HoodieInstant inflight = null;
        HoodieInstant completed = null;
        for (HoodieInstant instant : instants) {
            if (instant.isRequested()) {
                requested = instant;
                continue;
            }
            if (instant.isInflight()) {
                inflight = instant;
                continue;
            }
            completed = instant;
        }
        return new ActiveAction(requested, inflight, Objects.requireNonNull(completed));
    }

    public List<HoodieInstant> getPendingInstants() {
        ArrayList<HoodieInstant> instants = new ArrayList<HoodieInstant>(2);
        if (this.requested != null) {
            instants.add(this.requested);
        }
        if (this.inflight != null) {
            instants.add(this.inflight);
        }
        return instants;
    }

    public HoodieInstant getCompleted() {
        return this.completed;
    }

    public String getAction() {
        return this.completed.getAction();
    }

    public String getPendingAction() {
        return this.getPendingInstant().getAction();
    }

    public String getInstantTime() {
        return this.completed.getTimestamp();
    }

    public String getCompletionTime() {
        return this.completed.getCompletionTime();
    }

    public Option<byte[]> getCommitMetadata(HoodieTableMetaClient metaClient) {
        Option<byte[]> content = metaClient.getActiveTimeline().getInstantDetails(this.completed);
        if (content.isPresent() && content.get().length == 0) {
            return Option.empty();
        }
        return content;
    }

    public Option<byte[]> getRequestedCommitMetadata(HoodieTableMetaClient metaClient) {
        if (this.requested != null) {
            Option<byte[]> requestedContent = metaClient.getActiveTimeline().getInstantDetails(this.requested);
            if (!requestedContent.isPresent() || requestedContent.get().length == 0) {
                return Option.empty();
            }
            return requestedContent;
        }
        return Option.empty();
    }

    public Option<byte[]> getInflightCommitMetadata(HoodieTableMetaClient metaClient) {
        if (this.inflight != null) {
            Option<byte[]> inflightContent = metaClient.getActiveTimeline().getInstantDetails(this.inflight);
            if (!inflightContent.isPresent() || inflightContent.get().length == 0) {
                return Option.empty();
            }
            return inflightContent;
        }
        return Option.empty();
    }

    public byte[] getCleanPlan(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().readCleanerInfoAsBytes(this.getPendingInstant()).get();
    }

    public byte[] getCompactionPlan(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getCompactionRequestedInstant(this.getInstantTime())).get();
    }

    public byte[] getLogCompactionPlan(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getLogCompactionRequestedInstant(this.getInstantTime())).get();
    }

    protected HoodieInstant getPendingInstant() {
        if (this.requested != null) {
            return this.requested;
        }
        if (this.inflight != null) {
            return this.inflight;
        }
        throw new AssertionError((Object)"Pending instant does not exist.");
    }

    @Override
    public int compareTo(ActiveAction other) {
        return this.completed.getTimestamp().compareTo(other.completed.getTimestamp());
    }

    public String toString() {
        return this.getCompleted().getTimestamp() + "__" + this.getCompleted().getAction();
    }
}

