/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public class CompletionTimeQueryView
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long MILLI_SECONDS_IN_THREE_DAYS = 259200000L;
    private final HoodieTableMetaClient metaClient;
    private final Map<String, String> startToCompletionInstantTimeMap;
    private volatile String cursorInstant;
    private final String firstNonSavepointCommit;

    public CompletionTimeQueryView(HoodieTableMetaClient metaClient) {
        this(metaClient, HoodieInstantTimeGenerator.formatDate(new Date(Instant.now().minusMillis(259200000L).toEpochMilli())));
    }

    public CompletionTimeQueryView(HoodieTableMetaClient metaClient, String cursorInstant) {
        this.metaClient = metaClient;
        this.startToCompletionInstantTimeMap = new ConcurrentHashMap<String, String>();
        this.cursorInstant = HoodieTimeline.minInstant(cursorInstant, metaClient.getActiveTimeline().firstInstant().map(HoodieInstant::getTimestamp).orElse(""));
        this.firstNonSavepointCommit = metaClient.getActiveTimeline().getWriteTimeline().getFirstNonSavepointCommit().map(HoodieInstant::getTimestamp).orElse("");
        this.load();
    }

    public boolean isCompleted(String instantTime) {
        return this.startToCompletionInstantTimeMap.containsKey(instantTime) || HoodieTimeline.compareTimestamps(instantTime, HoodieTimeline.LESSER_THAN, this.firstNonSavepointCommit);
    }

    public boolean isCompletedBefore(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return HoodieTimeline.compareTimestamps(completionTimeOpt.get(), HoodieTimeline.LESSER_THAN, baseInstant);
        }
        return false;
    }

    public boolean isSlicedAfterOrOn(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return HoodieTimeline.compareTimestamps(completionTimeOpt.get(), HoodieTimeline.GREATER_THAN_OR_EQUALS, baseInstant);
        }
        return true;
    }

    public Option<String> getCompletionTime(String baseInstant, String instantTime) {
        String completionTime;
        Option<String> completionTimeOpt = this.getCompletionTime(instantTime);
        if (completionTimeOpt.isPresent() && (completionTime = completionTimeOpt.get()).length() != baseInstant.length()) {
            return Option.of(instantTime);
        }
        return completionTimeOpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<String> getCompletionTime(String startTime) {
        String completionTime = this.startToCompletionInstantTimeMap.get(startTime);
        if (completionTime != null) {
            return Option.of(completionTime);
        }
        if (HoodieTimeline.compareTimestamps(startTime, HoodieTimeline.GREATER_THAN_OR_EQUALS, this.cursorInstant)) {
            return Option.empty();
        }
        CompletionTimeQueryView completionTimeQueryView = this;
        synchronized (completionTimeQueryView) {
            if (HoodieTimeline.compareTimestamps(startTime, HoodieTimeline.LESSER_THAN, this.cursorInstant)) {
                HoodieArchivedTimeline.loadInstants(this.metaClient, new HoodieArchivedTimeline.ClosedOpenTimeRangeFilter(startTime, this.cursorInstant), HoodieArchivedTimeline.LoadMode.SLIM, r -> true, this::readCompletionTime);
            }
            this.cursorInstant = startTime;
        }
        return Option.ofNullable(this.startToCompletionInstantTimeMap.get(startTime));
    }

    private void load() {
        this.metaClient.getActiveTimeline().filterCompletedInstants().getInstantsAsStream().forEach(instant -> this.setCompletionTime(instant.getTimestamp(), instant.getCompletionTime()));
        HoodieArchivedTimeline.loadInstants(this.metaClient, new HoodieArchivedTimeline.StartTsFilter(this.cursorInstant), HoodieArchivedTimeline.LoadMode.SLIM, r -> true, this::readCompletionTime);
    }

    private void readCompletionTime(String instantTime, GenericRecord record) {
        String completionTime = record.get("completionTime").toString();
        this.setCompletionTime(instantTime, completionTime);
    }

    private void setCompletionTime(String instantTime, String completionTime) {
        if (completionTime == null) {
            completionTime = instantTime;
        }
        this.startToCompletionInstantTimeMap.putIfAbsent(instantTime, completionTime);
    }

    public String getCursorInstant() {
        return this.cursorInstant;
    }

    @Override
    public void close() throws Exception {
        this.startToCompletionInstantTimeMap.clear();
    }
}

