/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.exception.HoodieException;

public class HoodieInstantTimeGenerator {
    public static final String SECS_INSTANT_TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    public static final int SECS_INSTANT_ID_LENGTH = "yyyyMMddHHmmss".length();
    public static final String MILLIS_INSTANT_TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    public static final int MILLIS_INSTANT_ID_LENGTH = "yyyyMMddHHmmssSSS".length();
    public static final int MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH = "yyyyMMddHHmmssSSS".length();
    private static DateTimeFormatter MILLIS_INSTANT_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    private static final String MILLIS_GRANULARITY_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static DateTimeFormatter MILLIS_GRANULARITY_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static AtomicReference<String> lastInstantTime = new AtomicReference<String>(String.valueOf(Integer.MIN_VALUE));
    public static final String DEFAULT_MILLIS_EXT = "999";
    private static HoodieTimelineTimeZone commitTimeZone = HoodieTimelineTimeZone.LOCAL;

    public static String createNewInstantTime(boolean shouldLock, TimeGenerator timeGenerator, long milliseconds) {
        return lastInstantTime.updateAndGet(oldVal -> {
            Date d;
            String newCommitTime;
            do {
                d = new Date(timeGenerator.currentTimeMillis(!shouldLock) + milliseconds);
            } while (HoodieTimeline.compareTimestamps(newCommitTime = commitTimeZone.equals((Object)HoodieTimelineTimeZone.UTC) ? d.toInstant().atZone(HoodieTimelineTimeZone.UTC.getZoneId()).toLocalDateTime().format(MILLIS_INSTANT_TIME_FORMATTER) : MILLIS_INSTANT_TIME_FORMATTER.format(HoodieInstantTimeGenerator.convertDateToTemporalAccessor(d)), HoodieActiveTimeline.LESSER_THAN_OR_EQUALS, oldVal));
            return newCommitTime;
        });
    }

    public static Date parseDateFromInstantTime(String timestamp) throws ParseException {
        try {
            String timestampInMillis = HoodieInstantTimeGenerator.fixInstantTimeCompatibility(timestamp);
            LocalDateTime dt = LocalDateTime.parse(timestampInMillis, MILLIS_INSTANT_TIME_FORMATTER);
            return Date.from(dt.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new ParseException(e.getMessage(), e.getErrorIndex());
        }
    }

    public static String instantTimePlusMillis(String timestamp, long milliseconds) {
        try {
            String timestampInMillis = HoodieInstantTimeGenerator.fixInstantTimeCompatibility(timestamp);
            LocalDateTime dt = LocalDateTime.parse(timestampInMillis, MILLIS_INSTANT_TIME_FORMATTER);
            ZoneId zoneId = HoodieTimelineTimeZone.UTC.equals((Object)commitTimeZone) ? ZoneId.of("UTC") : ZoneId.systemDefault();
            return MILLIS_INSTANT_TIME_FORMATTER.format(dt.atZone(zoneId).toInstant().plusMillis(milliseconds).atZone(zoneId).toLocalDateTime());
        }
        catch (DateTimeParseException e) {
            throw new HoodieException(e);
        }
    }

    private static String fixInstantTimeCompatibility(String instantTime) {
        if (HoodieInstantTimeGenerator.isSecondGranularity(instantTime)) {
            return instantTime + DEFAULT_MILLIS_EXT;
        }
        if (instantTime.length() > MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH) {
            return instantTime.substring(0, MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH);
        }
        return instantTime;
    }

    private static boolean isSecondGranularity(String instant) {
        return instant.length() == SECS_INSTANT_ID_LENGTH;
    }

    public static String formatDate(Date timestamp) {
        return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(HoodieInstantTimeGenerator.convertDateToTemporalAccessor(timestamp));
    }

    public static String getInstantFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        return MILLIS_INSTANT_TIME_FORMATTER.format(temporalAccessor);
    }

    public static String getInstantForDateString(String dateString) {
        try {
            return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(LocalDateTime.parse(dateString, MILLIS_GRANULARITY_DATE_FORMATTER));
        }
        catch (Exception e) {
            return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(LocalDateTime.parse(String.format("%s.%s", dateString, DEFAULT_MILLIS_EXT), MILLIS_GRANULARITY_DATE_FORMATTER));
        }
    }

    private static TemporalAccessor convertDateToTemporalAccessor(Date d) {
        return d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static void setCommitTimeZone(HoodieTimelineTimeZone commitTimeZone) {
        HoodieInstantTimeGenerator.commitTimeZone = commitTimeZone;
    }

    public static boolean isValidInstantTime(String instantTime) {
        try {
            Long.parseLong(instantTime);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

