/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.model.HoodieLSMTimelineManifest;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.util.ArchivedInstantReadSchemas;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSMTimeline {
    private static final Logger LOG = LoggerFactory.getLogger(LSMTimeline.class);
    public static final int LSM_TIMELINE_INSTANT_VERSION_1 = 1;
    private static final String VERSION_FILE_NAME = "_version_";
    private static final String MANIFEST_FILE_PREFIX = "manifest_";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^(\\d+)_(\\d+)_(\\d)\\.parquet");

    public static Schema getReadSchema(HoodieArchivedTimeline.LoadMode loadMode) {
        switch (loadMode) {
            case SLIM: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_SLIM_READ_SCHEMA;
            }
            case METADATA: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_METADATA;
            }
            case PLAN: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_PLAN;
            }
        }
        throw new AssertionError((Object)"Unexpected");
    }

    public static boolean isFileInRange(HoodieArchivedTimeline.TimeRangeFilter filter, String fileName) {
        String minInstant = LSMTimeline.getMinInstantTime(fileName);
        String maxInstant = LSMTimeline.getMaxInstantTime(fileName);
        return filter.isInRange(minInstant) || filter.isInRange(maxInstant);
    }

    public static int latestSnapshotVersion(HoodieTableMetaClient metaClient) throws IOException {
        Path versionFilePath = LSMTimeline.getVersionFilePath(metaClient);
        if (metaClient.getFs().exists(versionFilePath)) {
            try {
                Option<byte[]> content = FileIOUtils.readDataFromPath(metaClient.getFs(), versionFilePath);
                if (content.isPresent()) {
                    return Integer.parseInt(new String(content.get(), StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                LOG.warn("Error reading version file {}", (Object)versionFilePath, (Object)e);
            }
        }
        return LSMTimeline.allSnapshotVersions(metaClient).stream().max(Integer::compareTo).orElse(-1);
    }

    public static List<Integer> allSnapshotVersions(HoodieTableMetaClient metaClient) throws IOException {
        return Arrays.stream(metaClient.getFs().listStatus(new Path(metaClient.getArchivePath()), LSMTimeline.getManifestFilePathFilter())).map(fileStatus -> fileStatus.getPath().getName()).map(LSMTimeline::getManifestVersion).collect(Collectors.toList());
    }

    public static HoodieLSMTimelineManifest latestSnapshotManifest(HoodieTableMetaClient metaClient) throws IOException {
        int latestVersion = LSMTimeline.latestSnapshotVersion(metaClient);
        return LSMTimeline.latestSnapshotManifest(metaClient, latestVersion);
    }

    public static HoodieLSMTimelineManifest latestSnapshotManifest(HoodieTableMetaClient metaClient, int latestVersion) {
        if (latestVersion < 0) {
            return HoodieLSMTimelineManifest.EMPTY;
        }
        byte[] content = FileIOUtils.readDataFromPath(metaClient.getFs(), LSMTimeline.getManifestFilePath(metaClient, latestVersion)).get();
        try {
            return HoodieLSMTimelineManifest.fromJsonString(new String(content, StandardCharsets.UTF_8), HoodieLSMTimelineManifest.class);
        }
        catch (Exception e) {
            throw new HoodieException("Error deserializing manifest entries", e);
        }
    }

    public static Path getManifestFilePath(HoodieTableMetaClient metaClient, int snapshotVersion) {
        return new Path(metaClient.getArchivePath(), MANIFEST_FILE_PREFIX + snapshotVersion);
    }

    public static Path getVersionFilePath(HoodieTableMetaClient metaClient) {
        return new Path(metaClient.getArchivePath(), VERSION_FILE_NAME);
    }

    public static FileStatus[] listAllManifestFiles(HoodieTableMetaClient metaClient) throws IOException {
        return metaClient.getFs().listStatus(new Path(metaClient.getArchivePath()), LSMTimeline.getManifestFilePathFilter());
    }

    public static FileStatus[] listAllMetaFiles(HoodieTableMetaClient metaClient) throws IOException {
        return metaClient.getFs().globStatus(new Path(metaClient.getArchivePath() + "/*.parquet"));
    }

    public static int getManifestVersion(String fileName) {
        return Integer.parseInt(fileName.split("_")[1]);
    }

    public static int getFileLayer(String fileName) {
        try {
            Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
            if (fileMatcher.matches()) {
                return Integer.parseInt(fileMatcher.group(3));
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("error getting file layout for archived file: " + fileName);
        }
        return 0;
    }

    public static String getMinInstantTime(String fileName) {
        Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
        if (fileMatcher.matches()) {
            return fileMatcher.group(1);
        }
        throw new HoodieException("Unexpected archival file name: " + fileName);
    }

    public static String getMaxInstantTime(String fileName) {
        Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
        if (fileMatcher.matches()) {
            return fileMatcher.group(2);
        }
        throw new HoodieException("Unexpected archival file name: " + fileName);
    }

    public static boolean isFileFromLayer(String fileName, int layer) {
        return LSMTimeline.getFileLayer(fileName) == layer;
    }

    public static PathFilter getManifestFilePathFilter() {
        return path -> path.getName().startsWith(MANIFEST_FILE_PREFIX) && !path.getName().endsWith(TEMP_FILE_SUFFIX);
    }
}

