/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGeneratorType;
import org.apache.hudi.common.table.timeline.WaitBasedTimeGenerator;
import org.apache.hudi.common.util.ValidationUtils;

public class TimeGenerators {
    private static final Cache<String, TimeGenerator> TIME_GENERATOR_CACHE = Caffeine.newBuilder().maximumSize(10L).weakValues().build();

    public static TimeGenerator getTimeGenerator(HoodieTimeGeneratorConfig timeGeneratorConfig, Configuration hadoopConf) {
        ValidationUtils.checkState(timeGeneratorConfig.contains(HoodieCommonConfig.BASE_PATH), "Option [" + HoodieCommonConfig.BASE_PATH.key() + "] is required");
        ValidationUtils.checkArgument(hadoopConf != null, "Hadoop configuration is required");
        return TIME_GENERATOR_CACHE.get(timeGeneratorConfig.getBasePath(), s -> {
            TimeGeneratorType type = timeGeneratorConfig.getTimeGeneratorType();
            switch (type) {
                case WAIT_TO_ADJUST_SKEW: {
                    return new WaitBasedTimeGenerator(timeGeneratorConfig, new SerializableConfiguration(hadoopConf));
                }
            }
            throw new IllegalArgumentException("Unsupported TimeGenerator Type " + (Object)((Object)type));
        });
    }
}

