/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.function.Consumer;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.table.timeline.TimeGeneratorBase;
import org.apache.hudi.exception.HoodieException;

public class WaitBasedTimeGenerator
extends TimeGeneratorBase {
    private final long maxExpectedClockSkewMs;

    public WaitBasedTimeGenerator(HoodieTimeGeneratorConfig config, SerializableConfiguration hadoopConf) {
        super(config, hadoopConf);
        this.maxExpectedClockSkewMs = config.getMaxExpectedClockSkewMs();
    }

    @Override
    public long currentTimeMillis(boolean skipLocking) {
        try {
            if (!skipLocking) {
                this.lock();
            }
            long ts = System.currentTimeMillis();
            Thread.sleep(this.maxExpectedClockSkewMs);
            long l = ts;
            return l;
        }
        catch (InterruptedException e) {
            throw new HoodieException("Interrupted when get the current time", e);
        }
        finally {
            if (!skipLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeTimestamp(boolean skipLocking, Consumer<Long> func) {
        try {
            if (!skipLocking) {
                this.lock();
            }
            long currentTimeMillis = this.currentTimeMillis(true);
            func.accept(currentTimeMillis);
        }
        finally {
            if (!skipLocking) {
                this.unlock();
            }
        }
    }
}

