/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.util.ValidationUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstantStateDTO {
    @JsonProperty(value="instant")
    String instant;
    @JsonProperty(value="state")
    String state;

    public static InstantStateDTO fromFileStatus(FileStatus fileStatus) {
        InstantStateDTO ret = new InstantStateDTO();
        String fileName = fileStatus.getPath().getName();
        String[] nameAndExt = fileName.split("\\.");
        ValidationUtils.checkState(nameAndExt.length == 2);
        ret.instant = nameAndExt[0];
        ret.state = nameAndExt[1];
        return ret;
    }

    public String getInstant() {
        return this.instant;
    }

    public String getState() {
        return this.state;
    }
}

