/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;

public class NumericUtils {
    public static String humanReadableByteCount(double bytes) {
        if (bytes < 1024.0) {
            return String.format("%.1f B", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f %sB", bytes / Math.pow(1024.0, exp), pre);
    }

    public static long getMessageDigestHash(String algorithmName, String string) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HoodieException(e);
        }
        return NumericUtils.asLong(Objects.requireNonNull(md).digest(StringUtils.getUTF8Bytes(string)));
    }

    public static long asLong(byte[] bytes) {
        ValidationUtils.checkState(bytes.length >= 8, "HashCode#asLong() requires >= 8 bytes.");
        return NumericUtils.padToLong(bytes);
    }

    public static long padToLong(byte[] bytes) {
        long retVal = bytes[0] & 0xFF;
        for (int i = 1; i < Math.min(bytes.length, 8); ++i) {
            retVal |= ((long)bytes[i] & 0xFFL) << i * 8;
        }
        return retVal;
    }
}

