/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.storage.HoodieAvroBootstrapFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReader;
import org.apache.hudi.io.storage.HoodieAvroOrcReader;
import org.apache.hudi.io.storage.HoodieAvroParquetReader;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;

public class HoodieAvroFileReaderFactory
extends HoodieFileReaderFactory {
    @Override
    protected HoodieFileReader newParquetFileReader(Configuration conf, Path path) {
        return new HoodieAvroParquetReader(conf, path);
    }

    @Override
    protected HoodieFileReader newHFileFileReader(Configuration conf, Path path) throws IOException {
        CacheConfig cacheConfig = new CacheConfig(conf);
        return new HoodieAvroHFileReader(conf, path, cacheConfig);
    }

    @Override
    protected HoodieFileReader newOrcFileReader(Configuration conf, Path path) {
        return new HoodieAvroOrcReader(conf, path);
    }

    @Override
    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        return new HoodieAvroBootstrapFileReader(skeletonFileReader, dataFileReader, partitionFields, partitionValues);
    }
}

