/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;

public class HoodieAvroOrcWriter
implements HoodieAvroFileWriter,
Closeable {
    private static final AtomicLong RECORD_INDEX = new AtomicLong(1L);
    private final long maxFileSize;
    private final Schema avroSchema;
    private final List<TypeDescription> fieldTypes;
    private final List<String> fieldNames;
    private final VectorizedRowBatch batch;
    private final Writer writer;
    private final Path file;
    private final HoodieWrapperFileSystem fs;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;
    private HoodieOrcConfig orcConfig;
    private String minRecordKey;
    private String maxRecordKey;

    public HoodieAvroOrcWriter(String instantTime, Path file, HoodieOrcConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        Configuration conf = FSUtils.registerFileSystem(file, config.getHadoopConf());
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, conf);
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(conf);
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
        this.avroSchema = schema;
        TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(this.avroSchema);
        this.fieldTypes = orcSchema.getChildren();
        this.fieldNames = orcSchema.getFieldNames();
        this.maxFileSize = config.getMaxFileSize();
        this.batch = orcSchema.createRowBatch();
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)conf).blockSize((long)config.getBlockSize()).stripeSize((long)config.getStripeSize()).compress(config.getCompressionKind()).bufferSize(config.getBlockSize()).fileSystem((FileSystem)this.fs).setSchema(orcSchema);
        this.writer = OrcFile.createWriter((Path)this.file, (OrcFile.WriterOptions)writerOptions);
        this.orcConfig = config;
    }

    @Override
    public void writeAvroWithMetadata(HoodieKey key, IndexedRecord avroRecord) throws IOException {
        this.prepRecordWithMetadata(key, avroRecord, this.instantTime, this.taskContextSupplier.getPartitionIdSupplier().get(), RECORD_INDEX.getAndIncrement(), this.file.getName());
        this.writeAvro(key.getRecordKey(), avroRecord);
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeAvro(String recordKey, IndexedRecord object) throws IOException {
        for (int col = 0; col < this.batch.numCols; ++col) {
            ColumnVector colVector = this.batch.cols[col];
            String thisField = this.fieldNames.get(col);
            TypeDescription type = this.fieldTypes.get(col);
            Object fieldValue = ((GenericRecord)object).get(thisField);
            Schema.Field avroField = this.avroSchema.getField(thisField);
            AvroOrcUtils.addToVector(type, colVector, avroField.schema(), fieldValue, this.batch.size);
        }
        ++this.batch.size;
        if (this.batch.size == this.batch.getMaxSize()) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
            this.batch.size = 0;
        }
        if (this.orcConfig.useBloomFilter()) {
            this.orcConfig.getBloomFilter().add(recordKey);
            this.minRecordKey = this.minRecordKey != null ? (this.minRecordKey.compareTo(recordKey) <= 0 ? this.minRecordKey : recordKey) : recordKey;
            this.maxRecordKey = this.maxRecordKey != null ? (this.maxRecordKey.compareTo(recordKey) >= 0 ? this.maxRecordKey : recordKey) : recordKey;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.batch.size != 0) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
        }
        if (this.orcConfig.useBloomFilter()) {
            BloomFilter bloomFilter = this.orcConfig.getBloomFilter();
            this.writer.addUserMetadata("org.apache.hudi.bloomfilter", ByteBuffer.wrap(StringUtils.getUTF8Bytes(bloomFilter.serializeToString())));
            if (this.minRecordKey != null && this.maxRecordKey != null) {
                this.writer.addUserMetadata("hoodie_min_record_key", ByteBuffer.wrap(StringUtils.getUTF8Bytes(this.minRecordKey)));
                this.writer.addUserMetadata("hoodie_max_record_key", ByteBuffer.wrap(StringUtils.getUTF8Bytes(this.maxRecordKey)));
            }
            if (bloomFilter.getBloomFilterTypeCode().name().contains("DYNAMIC")) {
                this.writer.addUserMetadata("hoodie_bloom_filter_type_code", ByteBuffer.wrap(StringUtils.getUTF8Bytes(bloomFilter.getBloomFilterTypeCode().name())));
            }
        }
        this.writer.addUserMetadata("orc.avro.schema", ByteBuffer.wrap(StringUtils.getUTF8Bytes(this.avroSchema.toString())));
        this.writer.close();
    }
}

