/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hudi.org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class TagUtil {
    static final Iterator<Tag> EMPTY_TAGS_ITR = new Iterator<Tag>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        @SuppressWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="Intentional")
        public Tag next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private TagUtil() {
    }

    public static List<Tag> asList(byte[] b, int offset, int length) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            tags.add(new ArrayBackedTag(b, pos, tagLen + 2));
        }
        return tags;
    }

    public static Pair<Integer, Integer> readVIntValuePart(Tag tag, int offset) throws IOException {
        if (tag.hasArray()) {
            return StreamUtils.readRawVarint32(tag.getValueArray(), offset);
        }
        return StreamUtils.readRawVarint32(tag.getValueByteBuffer(), offset);
    }

    public static List<Tag> carryForwardTags(Cell cell) {
        return TagUtil.carryForwardTags(null, cell);
    }

    public static List<Tag> carryForwardTags(List<Tag> tagsOrNull, Cell cell) {
        Iterator<Tag> itr = PrivateCellUtil.tagsIterator(cell);
        if (itr == EMPTY_TAGS_ITR) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        while (itr.hasNext()) {
            tags.add(itr.next());
        }
        return tags;
    }

    public static byte[] concatTags(byte[] tags, Cell cell) {
        int cellTagsLen = cell.getTagsLength();
        if (cellTagsLen == 0) {
            return tags;
        }
        byte[] b = new byte[tags.length + cellTagsLen];
        int pos = Bytes.putBytes(b, 0, tags, 0, tags.length);
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(b, ((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), pos, cellTagsLen);
        } else {
            Bytes.putBytes(b, pos, cell.getTagsArray(), cell.getTagsOffset(), cellTagsLen);
        }
        return b;
    }

    public static List<Tag> carryForwardTTLTag(List<Tag> tagsOrNull, long ttl) {
        if (ttl == Long.MAX_VALUE) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>(1);
        } else {
            Iterator<Tag> tagsItr = tags.iterator();
            while (tagsItr.hasNext()) {
                Tag tag = tagsItr.next();
                if (tag.getType() != 8) continue;
                tagsItr.remove();
                break;
            }
        }
        tags.add(new ArrayBackedTag(8, Bytes.toBytes(ttl)));
        return tags;
    }

    public static byte[] fromList(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        int length = 0;
        for (Tag tag : tags) {
            length += tag.getValueLength() + 3;
        }
        byte[] b = new byte[length];
        int pos = 0;
        for (Tag tag : tags) {
            int tlen = tag.getValueLength();
            pos = Bytes.putAsShort(b, pos, tlen + 1);
            pos = Bytes.putByte(b, pos, tag.getType());
            if (tag.hasArray()) {
                pos = Bytes.putBytes(b, pos, tag.getValueArray(), tag.getValueOffset(), tlen);
                continue;
            }
            ByteBufferUtils.copyFromBufferToArray(b, tag.getValueByteBuffer(), tag.getValueOffset(), pos, tlen);
            pos += tlen;
        }
        return b;
    }
}

