/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.balancer;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LocalityBasedCandidateGenerator
extends CandidateGenerator {
    LocalityBasedCandidateGenerator() {
    }

    @Override
    BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
        if (cluster.numRegions > 0) {
            int startIndex = ThreadLocalRandom.current().nextInt(cluster.numRegions);
            for (int i = 0; i < cluster.numRegions; ++i) {
                Optional<BaseLoadBalancer.Cluster.Action> potential;
                int region = (startIndex + i) % cluster.numRegions;
                int currentServer = cluster.regionIndexToServerIndex[region];
                if (currentServer == cluster.getOrComputeRegionsToMostLocalEntities(BaseLoadBalancer.Cluster.LocalityType.SERVER)[region] || !(potential = this.tryMoveOrSwap(cluster, currentServer, region, cluster.getOrComputeRegionsToMostLocalEntities(BaseLoadBalancer.Cluster.LocalityType.SERVER)[region])).isPresent()) continue;
                return potential.get();
            }
        }
        return BaseLoadBalancer.Cluster.NullAction;
    }

    private Optional<BaseLoadBalancer.Cluster.Action> tryMoveOrSwap(BaseLoadBalancer.Cluster cluster, int fromServer, int fromRegion, int toServer) {
        if (cluster.serverHasTooFewRegions(toServer)) {
            return Optional.of(this.getAction(fromServer, fromRegion, toServer, -1));
        }
        double fromRegionLocalityDelta = this.getWeightedLocality(cluster, fromRegion, toServer) - this.getWeightedLocality(cluster, fromRegion, fromServer);
        int toServertotalRegions = cluster.regionsPerServer[toServer].length;
        if (toServertotalRegions > 0) {
            int startIndex = ThreadLocalRandom.current().nextInt(toServertotalRegions);
            for (int i = 0; i < toServertotalRegions; ++i) {
                int toRegionIndex = (startIndex + i) % toServertotalRegions;
                int toRegion = cluster.regionsPerServer[toServer][toRegionIndex];
                double toRegionLocalityDelta = this.getWeightedLocality(cluster, toRegion, fromServer) - this.getWeightedLocality(cluster, toRegion, toServer);
                if (!(fromRegionLocalityDelta + toRegionLocalityDelta >= 0.0)) continue;
                return Optional.of(this.getAction(fromServer, fromRegion, toServer, toRegion));
            }
        }
        return Optional.empty();
    }

    private double getWeightedLocality(BaseLoadBalancer.Cluster cluster, int region, int server) {
        return cluster.getOrComputeWeightedLocality(region, server, BaseLoadBalancer.Cluster.LocalityType.SERVER);
    }
}

