/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class BackupMasterStatusTmplImpl
extends AbstractTemplateImpl
implements BackupMasterStatusTmpl.Intf {
    private final HMaster master;

    protected static BackupMasterStatusTmpl.ImplData __jamon_setOptionalArguments(BackupMasterStatusTmpl.ImplData p_implData) {
        return p_implData;
    }

    public BackupMasterStatusTmplImpl(TemplateManager p_templateManager, BackupMasterStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)BackupMasterStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        MasterAddressTracker masterAddressTracker = this.master.getMasterAddressTracker();
        if (!this.master.isActiveMaster()) {
            ServerName active_master;
            jamonWriter.write("\n    ");
            ServerName serverName = active_master = masterAddressTracker == null ? null : masterAddressTracker.getMasterAddress();
            assert (active_master != null) : "Failed to retrieve master's ServerName!";
            int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();
            jamonWriter.write("<div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Backup Master <small>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.master.getServerName().getHostname()), jamonWriter);
            jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <h4>Current Active Master: <a href=\"//");
            Escaping.HTML.write(StandardEmitter.valueOf((String)active_master.getHostname()), jamonWriter);
            jamonWriter.write(":");
            Escaping.HTML.write(StandardEmitter.valueOf((int)infoPort), jamonWriter);
            jamonWriter.write("/master-status\"\n        target=\"_blank\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)active_master.getHostname()), jamonWriter);
            jamonWriter.write("</a><h4>\n");
        } else {
            jamonWriter.write("\n    <h2>Backup Masters</h2>\n\n    <table class=\"table table-striped\">\n    <tr>\n        <th>ServerName</th>\n        <th>Port</th>\n        <th>Start Time</th>\n    </tr>\n    ");
            List<ServerName> backup_masters = this.master.getClusterMetricsWithoutCoprocessor(EnumSet.of(ClusterMetrics.Option.BACKUP_MASTERS)).getBackupMasterNames();
            Object[] backupServerNames = backup_masters.toArray(new ServerName[backup_masters.size()]);
            Arrays.sort(backupServerNames);
            for (Object serverName : backupServerNames) {
                int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getBackupMasterInfoPort((ServerName)serverName);
                jamonWriter.write("<tr>\n        <td><a href=\"//");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((ServerName)serverName).getHostname()), jamonWriter);
                jamonWriter.write(":");
                Escaping.HTML.write(StandardEmitter.valueOf((int)infoPort), jamonWriter);
                jamonWriter.write("/master-status\"\n            target=\"_blank\">");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((ServerName)serverName).getHostname()), jamonWriter);
                jamonWriter.write("</a>\n        </td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)((ServerName)serverName).getPort()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(((ServerName)serverName).getStartcode())), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("<tr><td>Total:");
            Escaping.HTML.write(StandardEmitter.valueOf((int)backupServerNames.length), jamonWriter);
            jamonWriter.write("</td>\n    </table>\n");
        }
        jamonWriter.write("\n");
    }
}

